/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.Path;
import juzu.impl.common.FileKey;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.template.TemplatePlugin;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.plugin.template.metamodel.ModelTemplateProcessContext;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.plugin.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(TemplateResolver.class);
    private final ApplicationMetaModel application;
    private Map<Path.Relative, juzu.impl.template.spi.Template<?>> templates;
    private Set<Path.Relative> emitted;
    private Map<Path.Relative, FileObject> classCache;

    public TemplateResolver(ApplicationMetaModel application) {
        if (application == null) {
            throw new NullPointerException();
        }
        this.application = application;
        this.templates = new HashMap();
        this.emitted = new HashSet<Path.Relative>();
        this.classCache = new HashMap<Path.Relative, FileObject>();
    }

    public Collection<juzu.impl.template.spi.Template<?>> getTemplates() {
        return this.templates.values();
    }

    public void removeTemplate(Path.Relative path) {
        this.templates.remove(path);
    }

    public void prePassivate() {
        log.log("Evicting cache " + this.emitted);
        this.emitted.clear();
        this.classCache.clear();
    }

    public void process(TemplateMetaModelPlugin plugin, ProcessingContext context) throws ProcessingException {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        log.log("Synchronizing existing templates " + this.templates.keySet());
        Iterator<juzu.impl.template.spi.Template<?>> i = this.templates.values().iterator();
        while (i.hasNext()) {
            juzu.impl.template.spi.Template<?> template = i.next();
            Path.Absolute absolute = metaModel.resolvePath(template.getRelativePath());
            FileObject resource = context.resolveResource(this.application.getHandle(), absolute);
            if (resource == null) {
                i.remove();
                log.log("Detected template removal " + template.getRelativePath());
                continue;
            }
            if (resource.getLastModified() > template.getLastModified()) {
                i.remove();
                log.log("Detected stale template " + template.getRelativePath());
                continue;
            }
            log.log("Template " + template.getRelativePath() + " is valid");
        }
        log.log("Building missing templates");
        HashMap copy = new HashMap(this.templates);
        for (TemplateMetaModel templateMetaModel : metaModel) {
            juzu.impl.template.spi.Template template = (juzu.impl.template.spi.Template)copy.get(templateMetaModel.getPath());
            if (template != null) continue;
            log.log("Compiling template " + templateMetaModel.getPath());
            ModelTemplateProcessContext compiler = new ModelTemplateProcessContext(templateMetaModel, new HashMap(copy), context);
            Collection<juzu.impl.template.spi.Template<?>> resolved = compiler.resolve(templateMetaModel);
            for (juzu.impl.template.spi.Template template2 : resolved) {
                copy.put(template2.getRelativePath(), template2);
            }
        }
        this.templates = copy;
        for (juzu.impl.template.spi.Template template : this.templates.values()) {
            Path.Relative originPath = template.getOrigin();
            TemplateMetaModel templateMeta = metaModel.get(originPath);
            LinkedHashSet<Name> types = new LinkedHashSet<Name>();
            for (TemplateRefMetaModel templateRefMetaModel : templateMeta.getRefs()) {
                ElementHandle.Field handle = templateRefMetaModel.getHandle();
                types.add(handle.getFQN());
            }
            Element[] elements = new Element[types.size()];
            boolean bl = false;
            for (Name type : types) {
                elements[++var11_18] = context.getTypeElement(type);
            }
            TemplateProvider provider = plugin.providers.get(template.getRelativePath().getExt());
            this.resolvedQualified(provider, template, context, elements);
            this.resolveScript(template, plugin, context, elements);
        }
    }

    private <M extends Serializable> void resolveScript(final juzu.impl.template.spi.Template<M> template, final TemplateMetaModelPlugin plugin, final ProcessingContext context, final Element[] elements) {
        context.executeWithin(elements[0], new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                final TemplatesMetaModel metaModel = TemplateResolver.this.application.getChild(TemplatesMetaModel.KEY);
                TemplateProvider provider = plugin.providers.get(template.getRelativePath().getExt());
                Path.Relative path = template.getRelativePath();
                if (!TemplateResolver.this.emitted.contains(path)) {
                    try {
                        EmitContext emitCtx = new EmitContext(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void createResource(String rawName, String ext, CharSequence content) throws IOException {
                                Path.Relative bar = template.getRelativePath().as(rawName, ext);
                                Path.Absolute absolute = metaModel.resolvePath(bar);
                                FileKey key = FileKey.newName(absolute);
                                FileObject scriptFile = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, key, elements);
                                Writer writer = null;
                                try {
                                    writer = scriptFile.openWriter();
                                    writer.append(content);
                                    log.log("Generated template script " + bar + " as " + scriptFile.toUri() + " with originating elements " + Arrays.asList(elements));
                                }
                                finally {
                                    Tools.safeClose(writer);
                                }
                            }
                        };
                        provider.emit(emitCtx, template);
                        TemplateResolver.this.emitted.add(path);
                    }
                    catch (IOException e) {
                        throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_SCRIPT.failure(e, template.getRelativePath());
                    }
                } else {
                    log.log("Template " + template.getRelativePath() + " was found in cache");
                }
                return null;
            }
        });
    }

    private <M extends Serializable> void resolvedQualified(TemplateProvider<?> provider, juzu.impl.template.spi.Template<M> template, ProcessingContext context, Element[] elements) {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        Path.Relative path = template.getRelativePath();
        if (this.classCache.containsKey(path)) {
            log.log("Template class " + path + " was found in cache");
            return;
        }
        Path.Absolute resolvedPath = metaModel.resolvePath(path);
        Writer writer = null;
        try {
            JavaFileObject classFile = context.createSourceFile(resolvedPath.getName(), elements);
            writer = classFile.openWriter();
            writer.append("package ").append(resolvedPath.getDirs()).append(";\n");
            writer.append("import ").append(TemplateDescriptor.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(TemplatePlugin.class.getCanonicalName()).append(";\n");
            writer.append("@").append(Generated.class.getName()).append("({})\n");
            writer.append("@").append(Path.class.getName()).append("(\"").append(path.getValue()).append("\")\n");
            writer.append("public class ").append(path.getRawName()).append(" extends ").append(Template.class.getName()).append("\n");
            writer.append("{\n");
            writer.append("@javax.inject.Inject\n");
            writer.append("public ").append(path.getRawName()).append("(").append(TemplatePlugin.class.getSimpleName()).append(" templatePlugin").append(")\n");
            writer.append("{\n");
            writer.append("super(templatePlugin, \"").append(path.getValue()).append("\"").append(", ").append(provider.getTemplateStubType().getName()).append(".class);\n");
            writer.append("}\n");
            writer.append("public static final ").append(TemplateDescriptor.class.getName()).append(" DESCRIPTOR = new ").append(TemplateDescriptor.class.getName()).append("(").append(resolvedPath.getName()).append(".class,").append(provider.getTemplateStubType().getName()).append(".class").append(");\n");
            String baseBuilderName = Template.Builder.class.getCanonicalName();
            if (template.getParameters() != null) {
                writer.append("public Builder builder() {\n");
                writer.append("return new Builder();\n");
                writer.append("}\n");
                writer.append("public Builder with() {\n");
                writer.append("return (Builder)super.with();\n");
                writer.append("}\n");
                writer.append("public class Builder extends ").append(baseBuilderName).append("\n");
                writer.append("{\n");
                for (String paramName : template.getParameters()) {
                    writer.append("public Builder ").append(paramName).append("(Object ").append(paramName).append(") {\n");
                    writer.append("set(\"").append(paramName).append("\",").append(paramName).append(");\n");
                    writer.append("return this;\n");
                    writer.append("}\n");
                }
                writer.append("}\n");
            } else {
                writer.append("public ").append(baseBuilderName).append(" builder() {\n");
                writer.append("return new ").append(baseBuilderName).append("();\n");
                writer.append("}\n");
            }
            writer.append("}\n");
            this.classCache.put(path, classFile);
            log.log("Generated template class " + path + " as " + classFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_CLASS.failure(e, elements[0], path);
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }
}

