/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import juzu.Method;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.common.Lexers;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.io.Stream;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestParameter;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletWebBridge
extends WebBridge
implements HttpContext,
ClientContext,
UserContext {
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private final String requestPath;
    private final String path;
    private final Method method;
    private final Logger log;
    private final Map<String, RequestParameter> requestParameters;

    public ServletWebBridge(HttpServletRequest req, HttpServletResponse resp, String path, Logger log) {
        RequestParameter requestParameter;
        Map requestParameters = Collections.emptyMap();
        String query = req.getQueryString();
        if (query != null) {
            Iterator<RequestParameter> i = Lexers.queryParser(query);
            while (i.hasNext()) {
                RequestParameter requestParameter2;
                if (requestParameters.isEmpty()) {
                    requestParameters = new HashMap();
                }
                requestParameter = (requestParameter = (RequestParameter)requestParameters.get((requestParameter2 = i.next()).getName())) != null ? requestParameter.append(requestParameter2) : requestParameter2;
                requestParameter.addTo(requestParameters);
            }
        }
        if ("POST".equals(req.getMethod()) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            try {
                for (Map.Entry<String, String[]> entry : HttpUtils.parsePostData((int)req.getContentLength(), (ServletInputStream)req.getInputStream()).entrySet()) {
                    if (requestParameters.isEmpty()) {
                        requestParameters = new HashMap();
                    }
                    requestParameter = (requestParameter = (RequestParameter)requestParameters.get(entry.getKey())) != null ? requestParameter.append(entry.getValue()) : RequestParameter.create(entry);
                    requestParameter.addTo(requestParameters);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.req = req;
        this.resp = resp;
        this.requestPath = req.getRequestURI().substring(req.getContextPath().length());
        this.path = path;
        this.method = Method.valueOf(req.getMethod());
        this.log = log;
        this.requestParameters = requestParameters;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.resp;
    }

    @Override
    public Map<String, RequestParameter> getParameters() {
        return this.requestParameters;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    @Override
    public void renderRequestURL(Appendable appendable) throws IOException {
        appendable.append(this.req.getScheme());
        appendable.append("://");
        appendable.append(this.req.getServerName());
        int port = this.req.getServerPort();
        if (port != 80) {
            appendable.append(':').append(Integer.toString(port));
        }
        appendable.append(this.req.getContextPath());
        appendable.append(this.path);
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case APPLICATION: {
                appendable.append(this.req.getContextPath()).append("/assets");
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Stream.Char getOutputStream() throws IOException {
        return new StreamImpl(this.resp.getWriter());
    }

    @Override
    protected void end(Stream.Char stream) {
        ((StreamImpl)stream).end();
    }

    @Override
    public ClientContext getClientContext() {
        return this;
    }

    @Override
    public HttpContext getHttpContext() {
        return this;
    }

    @Override
    public UserContext getUserContext() {
        return this;
    }

    @Override
    public ScopedContext getRequestScope(boolean create) {
        ScopedContext context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ScopedContext(this.log);
            this.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    @Override
    public ScopedContext getFlashScope(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ScopedContext(this.log);
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    @Override
    public ScopedContext getSessionScope(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ScopedContext(this.log);
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public void purgeSession() {
        HttpSession session = this.req.getSession(false);
        if (session != null) {
            for (String key : Tools.list(session.getAttributeNames())) {
                session.removeAttribute(key);
            }
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    @Override
    public void setContentType(String contentType) {
        this.resp.setContentType(contentType);
    }

    @Override
    public void setStatus(int status) {
        this.resp.setStatus(status);
    }

    @Override
    public String getContentType() {
        return this.req.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    @Override
    public int getContentLenth() {
        return this.req.getContentLength();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public int getServerPort() {
        return this.req.getServerPort();
    }

    @Override
    public String getServerName() {
        return this.req.getServerName();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public Locale getLocale() {
        return this.req.getLocale();
    }

    @Override
    public Iterable<Locale> getLocales() {
        return new Iterable<Locale>(){

            @Override
            public Iterator<Locale> iterator() {
                return new Iterator<Locale>(){
                    Enumeration<Locale> e;
                    {
                        this.e = ServletWebBridge.this.req.getLocales();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.e.hasMoreElements();
                    }

                    @Override
                    public Locale next() {
                        return this.e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    class StreamImpl
    implements Stream.Char {
        private final PrintWriter writer;
        private boolean closed;
        private AsyncContext context;

        StreamImpl(PrintWriter writer) {
            this.writer = writer;
        }

        public Stream.Char append(CharSequence csq) throws IOException {
            this.writer.append(csq);
            return this;
        }

        public Stream.Char append(CharSequence csq, int start, int end) throws IOException {
            this.writer.append(csq, start, end);
            return this;
        }

        public Stream.Char append(char c) throws IOException {
            this.writer.append(c);
            return this;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.context != null) {
                System.out.println("COMPLETING ASYNC");
                this.context.complete();
            }
        }

        void end() {
            if (!this.closed) {
                System.out.println("STARTING ASYNC");
                this.context = ServletWebBridge.this.req.startAsync();
            }
        }
    }
}

