/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import juzu.UndeclaredIOException;
import juzu.impl.common.PercentCodec;

class Path {
    private final Data data;
    private final int offset;
    private final String value;

    static Path parse(String path) throws UndeclaredIOException {
        try {
            Data data = new Data(path);
            return new Path(data, 0);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private Path(Data data, int offset) {
        this.data = data;
        this.offset = offset;
        this.value = data.value.substring(offset);
    }

    String getValue() {
        return this.value;
    }

    boolean isEscaped(int index) {
        return this.data.isEscaped(this.innerIndex(index));
    }

    char charAt(int pos) {
        return this.value.charAt(pos);
    }

    int length() {
        return this.value.length();
    }

    int indexOf(int c, int index) {
        return this.value.indexOf(c, index);
    }

    Path subPath(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative index accepted");
        }
        if (index == 0) {
            return this;
        }
        int i = this.offset + index;
        if (i > this.data.value.length()) {
            throw new IndexOutOfBoundsException("Index can't be greater than length");
        }
        return new Path(this.data, i);
    }

    private int innerIndex(int outterIndex) throws IndexOutOfBoundsException {
        if (outterIndex < 0) {
            throw new IndexOutOfBoundsException("No negative index accepted");
        }
        int pos = this.offset + outterIndex;
        if (pos > this.data.value.length()) {
            throw new IndexOutOfBoundsException("Index can't be greater than length");
        }
        return pos;
    }

    public String toString() {
        return "Path[" + this.value + "]";
    }

    private static final class Data {
        private final String value;
        private final boolean[] escaped;

        private Data(String rawValue) throws IOException, IllegalArgumentException {
            int delta;
            int len = rawValue.length();
            StringBuilder buffer = new StringBuilder();
            boolean[] escaped = new boolean[len];
            int count = 0;
            for (int i = 0; i < len; i += delta) {
                delta = PercentCodec.RFC3986_PATH.decodeChar(rawValue, i, len, buffer);
                escaped[count++] = delta > 1;
            }
            this.value = buffer.toString();
            this.escaped = escaped;
        }

        boolean isEscaped(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("No negative index accepted");
            }
            if (index >= this.value.length()) {
                throw new IndexOutOfBoundsException("Index can't be greater than length");
            }
            return this.escaped[index];
        }
    }
}

