/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Map;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestParameter
extends AbstractList<String> {
    private final String name;
    private final String[] raw;
    private final String[] value;

    public static RequestParameter create(String name, String value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        return new RequestParameter(name, null, new String[]{value});
    }

    public static RequestParameter create(String name, String raw, String value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        return new RequestParameter(name, new String[]{raw}, new String[]{value});
    }

    public static RequestParameter create(String name, String[] value) throws NullPointerException, IllegalArgumentException {
        return new RequestParameter(name, null, value);
    }

    public static RequestParameter create(Map.Entry<String, String[]> entry) throws NullPointerException, IllegalArgumentException {
        if (entry == null) {
            throw new NullPointerException("No null entry accepted");
        }
        String name = entry.getKey();
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        String[] value = entry.getValue();
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        return new RequestParameter(name, null, value);
    }

    private RequestParameter(String name, String[] raw, String[] value) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        for (String s : value) {
            if (s != null) continue;
            throw new IllegalArgumentException("Parameter value cannot contain null");
        }
        if (value.length == 0) {
            throw new IllegalArgumentException("Value length cannot be lesser than 1");
        }
        this.name = name;
        this.raw = raw;
        this.value = value;
    }

    @Override
    public String get(int index) {
        if (index < 0 || index > this.value.length) {
            throw new IndexOutOfBoundsException("Bad index " + index);
        }
        return this.value[index];
    }

    @Override
    public int size() {
        return this.value.length;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value[0];
    }

    public String getRaw(int index) {
        if (index < 0 || index > this.value.length) {
            throw new IndexOutOfBoundsException("Bad index " + index);
        }
        return this.raw != null ? this.raw[index] : null;
    }

    public String[] toArray() {
        return (String[])this.value.clone();
    }

    public <M extends Map<String, RequestParameter>> M addTo(M map) {
        map.put((String)this.name, (RequestParameter)this);
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RequestParameter) {
            RequestParameter that = (RequestParameter)obj;
            return this.name.equals(that.name) && Arrays.equals(this.value, that.value);
        }
        return false;
    }

    public RequestParameter append(RequestParameter appended) {
        return new RequestParameter(this.name, Tools.safeConcat(this.raw, appended.raw), Tools.safeConcat(this.value, appended.value));
    }

    public RequestParameter append(String[] appended) {
        String[] value = new String[this.value.length + 1];
        System.arraycopy(this.value, 0, value, 0, this.value.length);
        System.arraycopy(appended, 0, value, appended.length, this.value.length);
        return new RequestParameter(this.name, null, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RequestParameter[name=").append(this.name).append(",value=(");
        for (int i = 0; i < this.value.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.value[i]);
        }
        sb.append(")]");
        return sb.toString();
    }
}

