/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import juzu.impl.router.regex.GroupType;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NonCaptureGroupTransformation
extends REVisitor<RuntimeException> {
    NonCaptureGroupTransformation() {
    }

    @Override
    protected void visit(RENode.Disjunction disjunction) throws RuntimeException {
        super.visit(disjunction);
        if (disjunction.getParent() == null) {
            if (disjunction.hasAlternative()) {
                RENode.Alternative alternative = disjunction.getAlternative();
                disjunction.clearAlternative();
                if (disjunction.hasNext()) {
                    RENode.Disjunction next = disjunction.getNext();
                    disjunction.clearNext();
                    RENode.Alternative group = new RENode.Alternative(new RENode.Group(new RENode.Disjunction(alternative, next), GroupType.CAPTURING_GROUP));
                    disjunction.setAlternative(group);
                } else {
                    RENode.Alternative group = new RENode.Alternative(new RENode.Group(new RENode.Disjunction(alternative), GroupType.CAPTURING_GROUP));
                    disjunction.setAlternative(group);
                }
            } else if (disjunction.hasNext()) {
                RENode.Disjunction next = disjunction.getNext();
                disjunction.clearNext();
                RENode.Alternative group = new RENode.Alternative(new RENode.Group(new RENode.Disjunction(next), GroupType.CAPTURING_GROUP));
                disjunction.setAlternative(group);
            } else {
                RENode.Alternative group = new RENode.Alternative(new RENode.Group(new RENode.Disjunction(), GroupType.CAPTURING_GROUP));
                disjunction.setAlternative(group);
            }
        }
    }

    @Override
    protected void visit(RENode.Group expr) throws RuntimeException {
        if (expr.getType() == GroupType.CAPTURING_GROUP) {
            expr.setType(GroupType.NON_CAPTURING_GROUP);
        }
        super.visit(expr);
    }
}

