/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.tools.FileObject;
import juzu.impl.common.Content;
import juzu.impl.common.CycleDetectionException;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.Key;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaModelProcessContext
extends ProcessContext {
    private TemplatesMetaModel owner;
    private final ProcessingContext env;

    MetaModelProcessContext(TemplatesMetaModel owner) {
        this.owner = owner;
        this.env = owner.application.getProcessingContext();
    }

    void resolve(TemplateMetaModel metaModel) {
        this.resolveTemplate(metaModel.getPath());
    }

    @Override
    protected <M extends Serializable> Template<M> getTemplate(Path.Relative path) {
        TemplateMetaModel tmm = this.owner.get(path);
        if (tmm != null) {
            return tmm.template;
        }
        return null;
    }

    @Override
    protected <M extends Serializable> void registerTemplate(Template<M> template) {
        TemplateMetaModel related = this.owner.add(template.getRelativePath());
        if (related.template != null) {
            throw new UnsupportedOperationException("todo");
        }
        related.template = template;
    }

    @Override
    protected <M extends Serializable> void register(Path.Relative originPath, Template<M> template) {
        if (originPath != null) {
            Key<TemplateMetaModel> key;
            TemplateMetaModel a = this.owner.get(template.getRelativePath());
            TemplateMetaModel b = this.owner.get(originPath);
            if (b.getChild(key = Key.of(template.getAbsolutePath(), TemplateMetaModel.class)) == null) {
                try {
                    b.addChild(key, a);
                }
                catch (CycleDetectionException e) {
                    StringBuilder path = new StringBuilder();
                    for (Object node : e.getPath()) {
                        if (path.length() > 0) {
                            path.append("->");
                        }
                        if (node instanceof TemplateMetaModel) {
                            TemplateMetaModel templateNode = (TemplateMetaModel)node;
                            path.append(templateNode.getPath().getValue());
                            continue;
                        }
                        path.append(node);
                    }
                    throw TemplateMetaModel.TEMPLATE_CYCLE.failure(template.getRelativePath(), path);
                }
            }
        }
    }

    @Override
    protected TemplateProvider resolverProvider(String ext) {
        return this.owner.plugin.providers.get(ext);
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        MethodMetaModel method = this.owner.getApplication().getChild(ControllersMetaModel.KEY).resolve(typeName, methodName, parameterMap.keySet());
        if (method == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (ParameterMetaModel param : method.getParameters()) {
            if (!(param instanceof PhaseParameterMetaModel)) continue;
            String value = parameterMap.get(param.getName());
            args.add(value);
        }
        return new MethodInvocation(method.getController().getHandle().getFQN() + "_", method.getName(), args);
    }

    @Override
    public Resource<Timestamped<Content>> resolveResource(Path.Relative path) {
        FileObject resource = this.owner.application.resolveResource(TemplatesMetaModel.LOCATION, path);
        if (resource != null) {
            try {
                Path.Absolute foo = this.owner.resolvePath(path);
                byte[] bytes = Tools.bytes(resource.openInputStream());
                long lastModified = resource.getLastModified();
                Timestamped<Content> content = new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
                return new Resource<Timestamped<Content>>(foo, content);
            }
            catch (Exception e) {
                this.env.log("Could not get resource content " + path.getCanonical(), e);
            }
        }
        return null;
    }
}

