/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetServer {
    HashSet<ApplicationLifeCycle<?, ?>> runtimes = new HashSet();

    public void register(ApplicationLifeCycle<?, ?> assetManager) {
        this.runtimes.add(assetManager);
    }

    public void unregister(ApplicationLifeCycle<?, ?> assetManager) {
        this.runtimes.remove(assetManager);
    }

    public boolean doGet(String path, ServletContext ctx, HttpServletResponse resp) throws ServletException, IOException {
        if (path != null && path.length() > 0) {
            for (ApplicationLifeCycle<?, ?> runtime : this.runtimes) {
                Iterable<ResourceResolver> resolvers = runtime.resolveBeans(ResourceResolver.class);
                for (ResourceResolver resolver : resolvers) {
                    URL content = resolver.resolve(path);
                    InputStream in = content != null ? content.openStream() : ctx.getResourceAsStream(path);
                    if (in == null) continue;
                    int pos = path.lastIndexOf(47);
                    String name = pos == -1 ? path : path.substring(pos + 1);
                    String contentType = ctx.getMimeType(name);
                    if (contentType != null) {
                        resp.setContentType(contentType);
                    }
                    Tools.copy(in, resp.getOutputStream());
                    return true;
                }
            }
        }
        return false;
    }
}

