/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.tools.FileObject;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.MethodInvocationResolver;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.asset.Asset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetsMetaModel
extends MetaModelObject
implements MethodInvocationResolver {
    public static final MessageCode UNRESOLVED_ASSET = new MessageCode("UNRESOLVED_ASSET", "The application asset %1s cannot be resolved");
    public static final Key<AssetsMetaModel> KEY = Key.of(AssetsMetaModel.class);
    private final ArrayList<Asset> assets = new ArrayList();
    private final HashMap<String, URL> resources = new HashMap();

    public void addAsset(Asset asset) {
        URL url;
        if (AssetLocation.APPLICATION == asset.location && (url = this.resolve(asset.value)) != null) {
            this.add(asset.value, url);
        }
        this.assets.add(asset);
    }

    public void removeAsset(Asset asset) {
        URL url;
        if (AssetLocation.APPLICATION == asset.location && (url = this.resolve(asset.value)) != null) {
            this.remove(asset.value, url);
        }
        Iterator<Asset> i = this.assets.iterator();
        while (i.hasNext()) {
            Asset candidate = i.next();
            if (!asset.value.equals(candidate.value) || !asset.location.equals((Object)candidate.location)) continue;
            i.remove();
        }
    }

    public void add(String path, URL resource) {
        URL existing = this.resources.get(path);
        if (existing != null) {
            if (!existing.equals(resource)) {
                throw new UnsupportedOperationException("Resource conflict for path " + path + " : " + resource + " != " + existing);
            }
        } else {
            this.resources.put(path, resource);
        }
    }

    public void remove(String path, URL resource) {
        URL existing = this.resources.get(path);
        if (existing != null && existing.equals(resource)) {
            this.resources.remove(path);
        }
    }

    public URL getResource(String path) {
        return this.resources.get(path);
    }

    public Map<String, URL> getResources() {
        return this.resources;
    }

    public Iterable<Asset> getAssets() {
        return this.assets;
    }

    public Iterable<Asset> getAssets(final String type) {
        return new Iterable<Asset>(){

            @Override
            public Iterator<Asset> iterator() {
                final Iterator i = AssetsMetaModel.this.assets.iterator();
                return new Iterator<Asset>(){
                    Asset next = null;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null && i.hasNext()) {
                            Asset asset = (Asset)i.next();
                            if (!asset.type.equals(type)) continue;
                            this.next = asset;
                        }
                        return this.next != null;
                    }

                    @Override
                    public Asset next() {
                        if (this.hasNext()) {
                            Asset tmp = this.next;
                            this.next = null;
                            return tmp;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void removeAssets(String type) {
        Iterator<Asset> i = this.assets.iterator();
        while (i.hasNext()) {
            Asset asset = i.next();
            if (!asset.type.equals(type)) continue;
            i.remove();
        }
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) {
        String path;
        if ("Assets".equals(typeName) && methodName.equals("url") && (path = parameterMap.get("path")) != null) {
            return new MethodInvocation(AssetServer.class.getName(), "renderAssetURL", Collections.singletonList(path));
        }
        return null;
    }

    private URL resolve(String value) throws ProcessingException {
        ApplicationMetaModel application = (ApplicationMetaModel)this.metaModel;
        ProcessingContext context = application.getProcessingContext();
        Path path = Path.parse(value);
        if (path.isRelative()) {
            context.info("Found classpath asset " + value);
            Name qn = application.getHandle().getPackageName().append("assets");
            Path.Absolute absolute = qn.resolve(path);
            FileObject src = context.resolveResourceFromSourcePath(application.getHandle(), absolute);
            if (src != null) {
                URI uri = src.toUri();
                context.info("Found asset " + absolute + " on source path " + uri);
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw UNRESOLVED_ASSET.failure(uri).initCause(e);
                }
            }
            context.info("Could not find asset " + absolute + " on source path");
            return null;
        }
        return null;
    }
}

