/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import juzu.impl.common.Resource;
import juzu.impl.common.Spliterator;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMURLConnection;

public class RAMURLStreamHandler
extends URLStreamHandler {
    private RAMFileSystem fs;

    public RAMURLStreamHandler(RAMFileSystem fs) {
        this.fs = fs;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        Iterable<String> names = Spliterator.split(u.getPath().substring(1), '/');
        String[] path = (String[])this.fs.getPath(names);
        Timestamped<Resource> resource = null;
        if (path != null) {
            resource = this.fs.getResource(path);
        }
        if (resource != null) {
            return new RAMURLConnection(u, resource);
        }
        throw new IOException("Could not connect to non existing resource " + names);
    }
}

