/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import juzu.impl.common.Cardinality;
import juzu.impl.common.Tools;
import juzu.impl.request.ControlParameter;

public class PhaseParameter
extends ControlParameter {
    private final Cardinality cardinality;
    private final String alias;

    public PhaseParameter(String name, Class<?> type, Cardinality cardinality, String alias) throws NullPointerException {
        super(name, type);
        if (cardinality == null) {
            throw new NullPointerException("No null parameter cardinality accepted");
        }
        this.cardinality = cardinality;
        this.alias = alias;
    }

    public String getMappedName() {
        return this.alias != null ? this.alias : this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PhaseParameter) {
            PhaseParameter that = (PhaseParameter)obj;
            return super.equals(that) && this.cardinality.equals((Object)that.cardinality) && Tools.safeEquals(this.alias, that.alias);
        }
        return false;
    }
}

