/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.plugin.asset.AssetKey;

public class Asset
implements Serializable {
    public final String id;
    public final String type;
    public final Boolean header;
    public final List<String> depends;
    public final AssetKey key;
    public final String minified;
    public final Integer maxAge;

    public Asset(String type, Map<String, Serializable> asset) {
        String id = (String)((Object)asset.get("id"));
        String value = (String)((Object)asset.get("value"));
        List depends = (List)((Object)asset.get("depends"));
        AssetLocation location = AssetLocation.safeValueOf((String)((Object)asset.get("location")));
        Integer maxAge = (Integer)asset.get("maxAge");
        String minified = (String)((Object)asset.get("minified"));
        Boolean header = (Boolean)asset.get("header");
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (location == null) {
            throw new IllegalArgumentException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends != null ? depends : new ArrayList();
        this.key = new AssetKey(value, location);
        this.maxAge = maxAge;
        this.minified = minified;
        this.header = header;
    }

    public Asset(String id, String type, String value, String minified, List<String> depends, AssetLocation location, Integer maxAge, Boolean header) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        if (location == null) {
            throw new NullPointerException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends;
        this.key = new AssetKey(value, location);
        this.maxAge = maxAge;
        this.minified = minified;
        this.header = header;
    }

    public boolean isApplication() {
        return this.key.location == AssetLocation.APPLICATION;
    }

    public String getSource() {
        return this.key.value;
    }

    public String getMinifiedSource() {
        return this.minified;
    }

    public Map<String, String> getSources() {
        HashMap<String, String> sources = new HashMap<String, String>();
        sources.put(this.getSource(), this.key.value);
        String minifiedSource = this.getMinifiedSource();
        if (minifiedSource != null) {
            sources.put(minifiedSource, this.minified);
        }
        return sources;
    }

    public JSON getJSON() {
        JSON json = new JSON().set("value", this.key.value).set("minified", this.minified).set("location", this.key.location.toString()).set("type", this.type);
        if (this.maxAge != null) {
            json.set("max-age", this.maxAge);
        }
        if (this.depends != null) {
            json.set("depends", this.depends);
        }
        if (this.header != null) {
            json.set("header", this.header);
        }
        return json;
    }

    public InputStream open(URLConnection resource) throws IOException {
        return resource.getInputStream();
    }
}

