/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import juzu.impl.common.Tools;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.ReadFileSystem;

public class Snapshot<P>
extends HashMap<String, Long> {
    private FileSystemScanner<P> scanner;
    Map<String, Change> changes;

    public Snapshot(FileSystemScanner<P> scanner) {
        this.scanner = scanner;
        this.changes = new LinkedHashMap<String, Change>();
    }

    public boolean hasChanges() {
        return this.changes.size() > 0;
    }

    public Map<String, Change> getChanges() {
        return this.changes;
    }

    public Snapshot<P> scan() throws IOException {
        return Snapshot.scan(this);
    }

    private static <P> Snapshot<P> scan(final Snapshot<P> current) throws IOException {
        final FileSystemScanner<P> scanner = current.scanner;
        ReadFileSystem<FileSystemScanner<P>> fs = scanner.fs;
        final ArrayList<String> stack = scanner.stack;
        final Snapshot<P> next = new Snapshot<P>(scanner);
        fs.traverse(scanner, new Visitor<P>(){

            @Override
            public void enterDir(P dir, String name) throws IOException {
                stack.add(name);
            }

            @Override
            public void file(P file, String name) throws IOException {
                long stamp = scanner.stampOf(file);
                stack.add(name);
                String id = Tools.join('/', stack);
                stack.remove(stack.size() - 1);
                next.put(id, stamp);
                Long data = (Long)current.get(id);
                if (data == null) {
                    next.changes.put(id, Change.ADD);
                } else if (scanner.isModified(data, stamp)) {
                    next.changes.put(id, Change.UPDATE);
                }
            }

            @Override
            public void leaveDir(P dir, String name) throws IOException {
                stack.remove(scanner.stack.size() - 1);
            }
        });
        for (String id : current.keySet()) {
            if (next.containsKey(id)) continue;
            next.changes.put(id, Change.REMOVE);
        }
        return next;
    }
}

