/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package examples.tutorial;

import junit.framework.AssertionFailedError;
import juzu.impl.bridge.DescriptorBuilder;
import juzu.impl.inject.spi.InjectorProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

import java.io.File;
import java.net.URL;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public class WeatherServletTestCase extends WeatherTestCase {

  // tag::deployment[]
  @Deployment
  public static WebArchive deployment() {
    String webXml = DescriptorBuilder.DEFAULT.
        injector(InjectorProvider.INJECT_SPRING).
        listener("org.springframework.web.context.ContextLoaderListener").
        toWebXml();
    WebArchive war = ShrinkWrap.create(WebArchive.class);
    war.setWebXML(new StringAsset(webXml));
    war.addAsWebInfResource(new File("src/test/resources/applicationContext.xml"));
    war.addPackages(true, "examples.tutorial");
    return war;
  }
  // end::deployment[]

  // tag::getApplicationURL[]
  public URL getApplicationURL(String application) {
    try {
      return deploymentURL.toURI().resolve(application).toURL();
    }
    catch (Exception e) {
      AssertionFailedError afe = new AssertionFailedError();
      afe.initCause(e);
      throw afe;
    }
  }
  // end::getApplicationURL[]
}
