/*
 * Decompiled with CFR 0.152.
 */
package examples.tutorial;

import com.google.common.base.Function;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

@RunWith(value=Arquillian.class)
public abstract class WeatherTestCase {
    @ArquillianResource
    URL deploymentURL;
    @Drone
    WebDriver driver;

    public abstract URL getApplicationURL(String var1);

    @Test
    @RunAsClient
    public void testWeather1() throws Exception {
        URL url = this.getApplicationURL("weather1");
        this.driver.get(url.toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("The weather application"));
    }

    @Test
    @RunAsClient
    public void testWeather2() throws Exception {
        URL url = this.getApplicationURL("weather2");
        this.driver.get(url.toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("temperature in marseille"));
        Assert.assertTrue((boolean)body.getText().contains("20 degrees"));
    }

    @Test
    @RunAsClient
    public void testWeather3() throws Exception {
        URL url = this.getApplicationURL("weather3");
        this.driver.get(url.toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("temperature in marseille"));
        Assert.assertTrue((boolean)body.getText().contains("10 degrees"));
    }

    @Test
    @RunAsClient
    public void testWeather4() throws Exception {
        URL url = this.getApplicationURL("weather4");
        this.driver.get(url.toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("temperature in marseille"));
        Assert.assertTrue((String)("Was expecting to find <10 degrees> in " + body.getText()), (boolean)body.getText().contains("10 degrees"));
        WebElement parisElt = this.driver.findElement(By.linkText((String)"Paris"));
        parisElt.click();
        body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("temperature in paris"));
        Assert.assertTrue((boolean)body.getText().contains("10 degrees"));
    }

    @Test
    @RunAsClient
    public void testWeather5() throws Exception {
        URL url = this.getApplicationURL("weather5");
        this.driver.get(url.toString());
        WebElement locationElt = this.driver.findElement(By.cssSelector((String)"input[name='location']"));
        locationElt.sendKeys(new CharSequence[]{"bastia"});
        locationElt.submit();
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        Assert.assertTrue((boolean)body.getText().contains("temperature in bastia"));
        Assert.assertTrue((boolean)body.getText().contains("10 degrees"));
    }

    @Test
    @RunAsClient
    public void testWeather7() throws Exception {
        URL url = this.getApplicationURL("weather7");
        this.driver.get(url.toString());
        WebElement link = this.driver.findElement(By.tagName((String)"link"));
        String href = link.getAttribute("href");
        url = new URL(href);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testWeather8() throws Exception {
        URL url = this.getApplicationURL("weather8");
        this.driver.get(url.toString());
        WebElement p = (WebElement)new WebDriverWait(this.driver, 10L).until((Function)new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver input) {
                return input.findElement(By.cssSelector((String)"div.accordion-inner p"));
            }
        });
        Assert.assertTrue((boolean)p.getText().contains("temperature in marseille"));
        Assert.assertTrue((boolean)p.getText().contains("10 degrees"));
    }
}

