/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less4j.impl;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModelPlugin;
import juzu.plugin.less4j.Less;
import juzu.plugin.less4j.impl.CompilerLessSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelPluginImpl
extends ModuleMetaModelPlugin {
    public static final MessageCode GENERAL_PROBLEM = new MessageCode("GENERAL_PROBLEM", "%1$s:\n%2$s");
    public static final MessageCode COMPILATION_ERROR = new MessageCode("LESS_COMPILATION_ERROR", "%1$s in %2$s on line %3$s:\n%4$s");
    public static final MessageCode MALFORMED_PATH = new MessageCode("LESS_MALFORMED_PATH", "The resource path %1$s is malformed");
    static final Logger log = BaseProcessor.getLogger(MetaModelPluginImpl.class);
    private HashMap<Name, AnnotationState> annotations;

    public MetaModelPluginImpl() {
        super("less");
    }

    public void init(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Less.class);
    }

    public void processAnnotationAdded(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        Name pkg = key.getElement().getPackageName();
        log.info((CharSequence)("Adding less annotation for package " + pkg));
        this.annotations.put(pkg, added);
    }

    public void processAnnotationRemoved(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        Name pkg = key.getElement().getPackageName();
        log.info((CharSequence)("Removing less annotation for package " + pkg));
        this.annotations.remove(pkg);
    }

    public void postActivate(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePassivate(ModuleMetaModel metaModel) {
        HashMap<Name, AnnotationState> clone = this.annotations;
        this.annotations = null;
        for (Map.Entry<Name, AnnotationState> entry : clone.entrySet()) {
            AnnotationState annotation = entry.getValue();
            Name pkg = entry.getKey();
            ProcessingContext env = metaModel.processingContext;
            ElementHandle.Package pkgHandle = ElementHandle.Package.create((Name)pkg);
            PackageElement pkgElt = (PackageElement)env.get((ElementHandle)pkgHandle);
            Boolean minify = (Boolean)annotation.get((Object)"minify");
            List resources = (List)annotation.get((Object)"value");
            AnnotationMirror annotationMirror = Tools.getAnnotation((Element)pkgElt, (String)Less.class.getName());
            log.info((CharSequence)("Handling less annotation for package " + pkg + ": minify=" + minify + " resources=" + resources));
            if (resources == null || resources.size() <= 0) continue;
            Name assetPkg = pkg.append(new String[]{"assets"});
            for (String resource : resources) {
                LessCompiler.CompilationResult result;
                Path path;
                log.info((CharSequence)("Processing declared resource " + resource));
                try {
                    path = Path.parse((String)resource);
                }
                catch (IllegalArgumentException e) {
                    throw MALFORMED_PATH.failure((Element)pkgElt, annotationMirror, new Object[]{resource}).initCause((Throwable)e);
                }
                Path.Absolute to = assetPkg.resolve(path.as("css"));
                log.info((CharSequence)("Resource " + resource + " destination resolved to " + to));
                CompilerLessSource file = new CompilerLessSource(env, pkgHandle, assetPkg.resolve(path));
                ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                try {
                    result = compiler.compile((LessSource)file);
                }
                catch (Less4jException e) {
                    List errors = e.getErrors();
                    ArrayList<Message> messages = new ArrayList<Message>(errors.size());
                    for (LessCompiler.Problem error : errors) {
                        String text = error.getMessage() != null ? error.getMessage() : "There is an error in your .less file";
                        String errorName = error.getType().name();
                        LessSource source = error.getSource();
                        Message msg = source != null ? new Message(COMPILATION_ERROR, new Object[]{errorName, source.getName(), error.getLine(), text}) : new Message(GENERAL_PROBLEM, new Object[]{errorName, text});
                        log.info((CharSequence)msg.toDisplayString());
                        messages.add(msg);
                    }
                    throw new ProcessingException((Element)pkgElt, annotationMirror, messages);
                }
                try {
                    log.info((CharSequence)("Resource " + resource + " compiled about to write on disk as " + to));
                    FileObject fo = env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, to, new Element[0]);
                    Writer writer = fo.openWriter();
                    try {
                        writer.write(result.getCss());
                    }
                    finally {
                        Tools.safeClose((Closeable)writer);
                    }
                }
                catch (IOException e) {
                    log.info((CharSequence)("Resource " + to + " could not be written on disk"), (Throwable)e);
                }
            }
        }
    }
}

