/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less4j.impl;

import com.github.sommeri.less4j.LessSource;
import javax.tools.FileObject;
import juzu.impl.common.Path;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;

public class CompilerLessSource
extends LessSource {
    private final ProcessingContext processingContext;
    private final ElementHandle.Package context;
    private final Path.Absolute path;
    private String content;

    public CompilerLessSource(ProcessingContext processingContext, ElementHandle.Package context, Path.Absolute path) {
        this.processingContext = processingContext;
        this.context = context;
        this.path = path;
    }

    public LessSource relativeSource(String s) throws LessSource.FileNotFound, LessSource.CannotReadFile, LessSource.StringSourceException {
        Path.Absolute resolvedPath = this.path.getDirs().resolve(s);
        return new CompilerLessSource(this.processingContext, this.context, resolvedPath);
    }

    public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        if (this.content == null) {
            FileObject c = this.processingContext.resolveResourceFromSourcePath(this.context, this.path);
            if (c != null) {
                try {
                    this.content = c.getCharContent(true).toString();
                }
                catch (Exception e) {
                    this.processingContext.error((CharSequence)("Could not get content of " + this.path), (Throwable)e);
                    LessSource.CannotReadFile cannotReadFile = new LessSource.CannotReadFile();
                    cannotReadFile.initCause((Throwable)e);
                    throw cannotReadFile;
                }
            } else {
                throw new LessSource.FileNotFound();
            }
        }
        return this.content;
    }
}

