/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less4j.impl;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import juzu.asset.AssetLocation;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.asset.Asset;
import juzu.plugin.less4j.impl.MetaModelPluginImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessAsset
extends Asset {
    public final URL resource;

    private static String foo(String lessValue) {
        int pos = lessValue.lastIndexOf(46);
        if (pos == -1) {
            return lessValue + ".css";
        }
        return lessValue.substring(0, pos) + ".css";
    }

    public LessAsset(String id, String lessValue, List<String> depends, URL resource) {
        super(id, "stylesheet", LessAsset.foo(lessValue), depends, AssetLocation.APPLICATION);
        this.resource = resource;
    }

    public InputStream filter(InputStream stream) throws IOException {
        ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
        try {
            LessCompiler.CompilationResult result = compiler.compile(this.resource);
            return new ByteArrayInputStream(result.getCss().getBytes());
        }
        catch (Less4jException e) {
            List errors = e.getErrors();
            ArrayList<Message> messages = new ArrayList<Message>(errors.size());
            for (LessCompiler.Problem error : errors) {
                String text = error.getMessage() != null ? error.getMessage() : "There is an error in your .less file";
                String errorName = error.getType().name();
                LessSource source = error.getSource();
                Message msg = source != null ? new Message(MetaModelPluginImpl.COMPILATION_ERROR, new Object[]{errorName, source.getName(), error.getLine(), text}) : new Message(MetaModelPluginImpl.GENERAL_PROBLEM, new Object[]{errorName, text});
                MetaModelPluginImpl.log.info((CharSequence)msg.toDisplayString());
                messages.add(msg);
            }
            throw new ProcessingException(messages);
        }
    }
}

