/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.portlet.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.plugin.portlet.Portlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode CANNOT_WRITE_PORTLET_CLASS = new MessageCode("CANNOT_WRITE_PORTLET_CLASS", "The portlet class %1$s cannot be written");
    private static final Name PORTLET = Name.create(Portlet.class);
    private final HashMap<ElementHandle.Package, String[]> enabledMap = new HashMap();
    private HashSet<ElementHandle.Package> toEmit = new HashSet();

    public PortletMetaModelPlugin() {
        super("portlet");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Portlet.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        ElementHandle.Package pkg = metaModel.getHandle();
        if (key.getType().equals((Object)PORTLET) && key.getElement().getPackage().equals((Object)pkg.getPackage())) {
            String name = (String)added.get((Object)"name");
            if (name == null) {
                name = metaModel.getBaseName() + "Portlet";
            }
            this.enabledMap.put(pkg, new String[]{name, metaModel.getName().toString()});
            this.toEmit.add(pkg);
        }
    }

    public void destroy(ApplicationMetaModel application) {
        this.enabledMap.remove(application.getHandle());
    }

    public void postProcessEvents(ApplicationMetaModel application) {
        ElementHandle.Package pkg = application.getHandle();
        String[] names = this.enabledMap.get(pkg);
        if (names != null) {
            PackageElement pkgElt = (PackageElement)application.model.processingContext.get((ElementHandle)pkg);
            AnnotationMirror am = Tools.getAnnotation((Element)pkgElt, (String)Portlet.class.getName());
            if (am == null) {
                this.enabledMap.remove(pkg);
                this.toEmit.remove(pkg);
            } else if (this.toEmit.contains(pkg)) {
                this.toEmit.remove(pkg);
                this.emitPortlet(application.model.processingContext, pkgElt, names);
            }
        }
    }

    private void emitPortlet(ProcessingContext env, PackageElement pkgElt, String[] names) throws ProcessingException {
        Writer writer = null;
        Name fqn = Name.parse((CharSequence)pkgElt.getQualifiedName()).append(new String[]{names[0]});
        try {
            JavaFileObject file = env.createSourceFile(fqn, new Element[]{pkgElt});
            writer = file.openWriter();
            writer.append("package ").append(pkgElt.getQualifiedName()).append(";\n");
            writer.append("import ").append(Generated.class.getCanonicalName()).append(";\n");
            writer.append("@Generated(value={})\n");
            writer.append("public class ").append(names[0]).append(" extends ").append(JuzuPortlet.class.getName()).append(" {\n");
            writer.append("@Override\n");
            writer.append("protected String getApplicationName(javax.portlet.PortletConfig config) {\n");
            writer.append("return \"").append(names[1]).append("\";\n");
            writer.append("}\n");
            writer.append("}\n");
        }
        catch (IOException e) {
            try {
                throw CANNOT_WRITE_PORTLET_CLASS.failure(new Object[]{e, pkgElt, fqn});
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose((Closeable)writer);
    }

    public JSON getDescriptor(ApplicationMetaModel application) {
        return new JSON();
    }
}

