/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.servlet.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.plugin.servlet.Servlet;

public class ServletMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode CANNOT_WRITE_SERVLET_CLASS = new MessageCode("CANNOT_WRITE_SERVLET_CLASS", "The servlet class %1$s cannot be written");
    private final HashMap<ElementHandle.Package, AnnotationState> servlets = new HashMap();

    public ServletMetaModelPlugin() {
        super("servlet");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Servlet.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        ElementHandle.Package pkg = metaModel.getHandle();
        if (key.getElement().getPackageName().equals((Object)pkg.getPackageName())) {
            this.servlets.put(pkg, added);
        }
    }

    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        ElementHandle.Package pkg = metaModel.getHandle();
        if (key.getElement().getPackageName().equals((Object)pkg.getPackageName())) {
            this.servlets.remove(pkg);
        }
    }

    public void postProcessAnnotations(ApplicationMetaModel metaModel) {
        ElementHandle.Package pkg = metaModel.getHandle();
        AnnotationState annotation = this.servlets.remove(pkg);
        if (annotation != null) {
            PackageElement pkgElt = (PackageElement)metaModel.processingContext.get((ElementHandle)pkg);
            String urlPattern = (String)annotation.get((Object)"value");
            String simpleName = (String)annotation.get((Object)"name");
            String resourceBundle = (String)annotation.get((Object)"resourceBundle");
            if (simpleName == null) {
                simpleName = metaModel.getBaseName() + "Servlet";
            }
            Name clazz = pkg.getPackageName().append(new String[]{simpleName});
            Writer writer = null;
            try {
                JavaFileObject file = metaModel.processingContext.createSourceFile(clazz, new Element[]{pkgElt});
                writer = file.openWriter();
                writer.append("package ").append((CharSequence)pkg.getPackageName()).append(";\n");
                writer.append("import javax.servlet.annotation.WebServlet;\n");
                writer.append("import javax.servlet.annotation.WebInitParam;\n");
                writer.append("@WebServlet(name=\"").append(simpleName).append("\",urlPatterns=\"").append(urlPattern).append("\"");
                if (resourceBundle != null) {
                    writer.append(",initParams=@WebInitParam(name=\"juzu.resource_bundle\",value=\"").append(resourceBundle).append("\")");
                }
                writer.append(")\n");
                writer.append("public class ").append(simpleName).append(" extends juzu.bridge.servlet.JuzuServlet {\n");
                writer.append("@Override\n");
                writer.append("protected String getApplicationName(javax.servlet.ServletConfig config) {\n");
                writer.append("return \"").append((CharSequence)pkg.getPackageName()).append("\";\n");
                writer.append("}\n");
                writer.append("}\n");
            }
            catch (IOException e) {
                try {
                    throw CANNOT_WRITE_SERVLET_CLASS.failure(new Object[]{e, pkgElt, pkg.getPackageName()});
                }
                catch (Throwable throwable) {
                    Tools.safeClose(writer);
                    throw throwable;
                }
            }
            Tools.safeClose((Closeable)writer);
        }
    }
}

