/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.webjars.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.webjars.WebJars;
import org.webjars.WebJarAssetLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJarsMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode MISSING_WEBJAR = new MessageCode("MISSING_WEBJAR", "Missing Webjar %1$s");
    public static final MessageCode INVALID_WEBJAR = new MessageCode("INVALID_WEBJAR", "Invalid Webjar %1$s %2$s");
    static final Logger log = BaseProcessor.getLogger(WebJarsMetaModelPlugin.class);

    public WebJarsMetaModelPlugin() {
        super("webjars");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(WebJars.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        Name pkg = key.getElement().getPackageName();
        AssetsMetaModel assetsMetaModel = (AssetsMetaModel)metaModel.getChild(AssetsMetaModel.KEY);
        for (Map.Entry<String, URL> entry : this.getAssets(metaModel, added).entrySet()) {
            assetsMetaModel.addResource(entry.getKey(), entry.getValue());
        }
    }

    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        Name pkg = key.getElement().getPackageName();
        AssetsMetaModel assetsMetaModel = (AssetsMetaModel)metaModel.getChild(AssetsMetaModel.KEY);
        for (Map.Entry<String, URL> entry : this.getAssets(metaModel, removed).entrySet()) {
            assetsMetaModel.removeResource(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, URL> getAssets(ApplicationMetaModel metaModel, AnnotationState annotation) {
        Map<String, URL> ret = Collections.emptyMap();
        Name pkg = metaModel.getHandle().getPackageName();
        ProcessingContext env = metaModel.processingContext;
        List webJars = (List)annotation.get((Object)"value");
        if (webJars != null && webJars.size() > 0) {
            for (AnnotationState webJar : webJars) {
                log.info((CharSequence)("Processing declared webjars " + webJar));
                String id = (String)webJar.get((Object)"value");
                String version = (String)webJar.get((Object)"version");
                if (version == null || version.length() == 0) {
                    String path = "META-INF/maven/org.webjars/" + id + "/pom.properties";
                    URL resource = WebJarAssetLocator.class.getClassLoader().getResource(path);
                    ElementHandle.Package pkgHandle = ElementHandle.Package.create((Name)pkg);
                    PackageElement pkgElt = (PackageElement)env.get((ElementHandle)pkgHandle);
                    if (resource == null) {
                        throw MISSING_WEBJAR.failure((Element)pkgElt, new Object[]{id});
                    }
                    Properties props = new Properties();
                    InputStream in = null;
                    try {
                        in = resource.openStream();
                        props.load(in);
                        version = props.getProperty("version");
                    }
                    catch (IOException e) {
                        throw INVALID_WEBJAR.failure((Element)pkgElt, new Object[]{id, "Could not read " + path}).initCause((Throwable)e);
                    }
                    finally {
                        Tools.safeClose((Closeable)in);
                    }
                    if (version == null) {
                        throw INVALID_WEBJAR.failure((Element)pkgElt, new Object[]{id, "No version found in " + path});
                    }
                }
                WebJarAssetLocator locator = new WebJarAssetLocator();
                String folderPath = "/" + id + "/" + version;
                Set assetsPaths = locator.listAssets(folderPath);
                log.info((CharSequence)("Webjars " + webJar + " resolved assets " + assetsPaths + " from " + folderPath));
                for (String assetPath : assetsPaths) {
                    URL assetURL = WebJarAssetLocator.class.getClassLoader().getResource(assetPath);
                    if (assetURL != null) {
                        String dst = assetPath.substring("META-INF/resources/webjars".length() + 1);
                        log.info((CharSequence)("Webjars " + webJar + " adding asset resource " + assetPath));
                        if (ret.isEmpty()) {
                            ret = new HashMap<String, URL>();
                        }
                        ret.put(dst, assetURL);
                        continue;
                    }
                    log.info((CharSequence)("Could not resolve WebJars asset " + webJar + " with resource path " + assetPath));
                }
            }
        }
        return ret;
    }
}

