/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.plugin.amd.Defines;
import juzu.plugin.amd.Requires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMDMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private HashMap<ElementHandle.Package, AnnotationState> defines = new HashMap();
    private HashMap<ElementHandle.Package, AnnotationState> requires = new HashMap();

    public AMDMetaModelPlugin() {
        super("amd");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Tools.set(Defines.class, Requires.class);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals(Name.create(Defines.class))) {
            this.defines.put(metaModel.getHandle(), added);
        } else if (key.getType().equals(Name.create(Requires.class))) {
            this.requires.put(metaModel.getHandle(), added);
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getType().equals(Name.create(Defines.class))) {
            this.defines.remove(metaModel.getHandle());
        } else if (key.getType().equals(Name.create(Requires.class))) {
            this.requires.remove(metaModel.getHandle());
        }
    }

    @Override
    public void prePassivate(ApplicationMetaModel metaModel) {
        AnnotationState defineState = this.defines.get(metaModel.getHandle());
        this.process(defineState, metaModel);
        AnnotationState requireState = this.requires.get(metaModel.getHandle());
        this.process(requireState, metaModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(AnnotationState annotation, ApplicationMetaModel metaModel) {
        if (annotation != null) {
            String location = (String)annotation.get("location");
            boolean classpath = location == null || AssetLocation.APPLICATION.equals((Object)AssetLocation.safeValueOf(location));
            List modules = (List)annotation.get("value");
            ProcessingContext context = metaModel.getProcessingContext();
            if (modules != null) {
                for (AnnotationState module : modules) {
                    String value;
                    Path path;
                    location = (String)module.get("location");
                    if ((location != null || !classpath) && !AssetLocation.APPLICATION.equals((Object)AssetLocation.safeValueOf(location)) || !(path = Path.parse(value = (String)module.get("path"))).isRelative()) continue;
                    context.log("Found classpath asset to copy " + value);
                    Name qn = metaModel.getHandle().getPackage().append("assets");
                    Path.Absolute absolute = qn.resolve(path);
                    FileObject src = context.resolveResourceFromSourcePath(metaModel.getHandle(), absolute);
                    if (src != null) {
                        OutputStream out;
                        InputStream in;
                        block9: {
                            URI srcURI = src.toUri();
                            context.log("Found asset " + absolute + " on source path " + srcURI);
                            in = null;
                            out = null;
                            try {
                                FileObject dst = context.getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute);
                                if (dst == null || dst.getLastModified() < src.getLastModified()) {
                                    in = src.openInputStream();
                                    dst = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute, context.get(metaModel.getHandle()));
                                    context.log("Copying asset from source path " + srcURI + " to class output " + dst.toUri());
                                    out = dst.openOutputStream();
                                    Tools.copy(in, out);
                                    break block9;
                                }
                                context.log("Found up to date related asset in class output for " + srcURI);
                            }
                            catch (IOException e) {
                                try {
                                    context.log("Could not copy asset " + path + " ", e);
                                }
                                catch (Throwable throwable) {
                                    Tools.safeClose(in);
                                    Tools.safeClose(out);
                                    throw throwable;
                                }
                                Tools.safeClose(in);
                                Tools.safeClose(out);
                                continue;
                            }
                        }
                        Tools.safeClose(in);
                        Tools.safeClose(out);
                        continue;
                    }
                    context.log("Could not find asset " + absolute + " on source path");
                }
            }
        }
    }

    private List<JSON> build(List<Map<String, Object>> scripts) {
        List<JSON> foo = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            foo = new ArrayList<JSON>(scripts.size());
            for (Map<String, Object> script : scripts) {
                JSON bar = new JSON();
                for (Map.Entry<String, Object> entry : script.entrySet()) {
                    bar.set(entry.getKey(), entry.getValue());
                }
                foo.add(bar);
            }
        }
        return foo;
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        AnnotationState definesState = this.defines.get(application.getHandle());
        AnnotationState requiresState = this.requires.get(application.getHandle());
        JSON config = null;
        if (definesState != null) {
            config = new JSON();
            JSON definesJSON = new JSON();
            List defines = (List)definesState.get("value");
            definesJSON.set("value", this.build(defines));
            definesJSON.set("location", definesState.get("location"));
            config.set("defines", definesJSON);
        }
        if (requiresState != null) {
            if (config == null) {
                config = new JSON();
            }
            JSON requiresJSON = new JSON();
            List requires = (List)requiresState.get("value");
            requiresJSON.set("value", this.build(requires));
            requiresJSON.set("location", requiresState.get("location"));
            config.set("requires", requiresJSON);
        }
        if (config != null) {
            config.set("package", "assets");
        }
        return config;
    }
}

