/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.jar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.io.UndeclaredIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileSystem
extends ReadFileSystem<String> {
    private final URL baseURL;
    private final TreeMap<String, ZipEntry> entries;

    public JarFileSystem(JarFile f) throws IOException {
        TreeMap<String, ZipEntry> entries = new TreeMap<String, ZipEntry>();
        Enumeration<JarEntry> en = f.entries();
        while (en.hasMoreElements()) {
            int index;
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            if (name.length() <= 0 || name.charAt(name.length() - 1) == '/') continue;
            entries.put(name, entry);
            String current = name;
            while ((index = current.lastIndexOf(47)) != -1 && !entries.containsKey(current = name.substring(0, index))) {
                entries.put(current, null);
            }
        }
        this.baseURL = new File(f.getName()).toURI().toURL();
        this.entries = entries;
    }

    public JarFileSystem(URL baseURL) throws IOException {
        final ZipInputStream in = new ZipInputStream(baseURL.openStream());
        try {
            this.baseURL = baseURL;
            this.entries = this.entries(new Enumeration<ZipEntry>(){
                ZipEntry next;

                @Override
                public boolean hasMoreElements() {
                    try {
                        if (this.next == null) {
                            this.next = in.getNextEntry();
                        }
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw new UndeclaredIOException(e);
                    }
                }

                @Override
                public ZipEntry nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    ZipEntry tmp = this.next;
                    this.next = null;
                    return tmp;
                }
            });
        }
        catch (UndeclaredIOException e) {
            throw e.getCause();
        }
        finally {
            Tools.safeClose(in);
        }
    }

    private TreeMap<String, ZipEntry> entries(Enumeration<ZipEntry> e) {
        TreeMap<String, ZipEntry> entries = new TreeMap<String, ZipEntry>();
        while (e.hasMoreElements()) {
            int index;
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (name.length() <= 0 || name.charAt(name.length() - 1) == '/') continue;
            entries.put(name, entry);
            String current = name;
            while ((index = current.lastIndexOf(47)) != -1 && !entries.containsKey(current = name.substring(0, index))) {
                entries.put(current, null);
            }
        }
        return entries;
    }

    @Override
    public boolean equals(String left, String right) {
        return left.equals(right);
    }

    @Override
    public String getRoot() throws IOException {
        return "";
    }

    @Override
    public String getChild(String dir, String name) throws IOException {
        String key = dir + name;
        if (this.entries.containsKey(key)) {
            if (this.entries.get(key) != null) {
                return key;
            }
            return key + "/";
        }
        return null;
    }

    @Override
    public long getLastModified(String path) throws IOException {
        if (path.isEmpty()) {
            return 1L;
        }
        ZipEntry entry = this.entries.get(path);
        return entry.getTime();
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getName(String path) {
        int index;
        if (path.isEmpty()) {
            return "";
        }
        int from = path.length();
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            --from;
        }
        return (index = path.lastIndexOf(47, from - 1)) == -1 ? path.substring(0, from) : path.substring(index + 1, from);
    }

    @Override
    public Iterator<String> getChildren(final String dir) throws IOException {
        final Iterator<String> i = this.entries.navigableKeySet().tailSet(dir, false).iterator();
        return new Iterator<String>(){
            String next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    String next;
                    while (i.hasNext() && (next = (String)i.next()).startsWith(dir)) {
                        int pos = next.lastIndexOf(47);
                        if (pos == -1) {
                            if (!dir.isEmpty()) continue;
                            this.next = next;
                            break;
                        }
                        if (pos != dir.length() - 1) continue;
                        this.next = next;
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String ret = JarFileSystem.this.entries.get(this.next) != null ? this.next : this.next + "/";
                    this.next = null;
                    return ret;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public PathType typeOf(String path) throws IOException {
        if (path.isEmpty() || path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            return PathType.DIR;
        }
        return PathType.FILE;
    }

    @Override
    public Timestamped<Content> getContent(String file) throws IOException {
        URL url = this.getURL(file);
        URLConnection conn = url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
    }

    @Override
    public File getFile(String path) {
        return null;
    }

    @Override
    public URL getURL(String path) throws NullPointerException, IOException {
        return new URL("jar:" + this.baseURL + "!/" + path);
    }
}

