/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.impl.common.Formatting;
import juzu.impl.compiler.CompilationException;
import juzu.io.OutputStream;
import juzu.io.Stream;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRenderBridge
extends PortletMimeBridge<RenderRequest, RenderResponse>
implements RenderBridge {
    public PortletRenderBridge(Bridge bridge, RenderRequest request, RenderResponse response, PortletConfig config) {
        super(bridge, request, response, config);
    }

    @Override
    protected Phase getPhase() {
        return Phase.VIEW;
    }

    @Override
    public Stream createStream(String mimeType, Charset charset) throws IOException {
        if (mimeType != null) {
            ((RenderResponse)this.resp).setContentType(mimeType);
        }
        return OutputStream.create(charset, ((RenderResponse)this.resp).getWriter());
    }

    @Override
    public void invoke() throws Exception {
        try {
            this.bridge.refresh();
        }
        catch (CompilationException e) {
            StringWriter buffer = new StringWriter();
            PrintWriter printer = new PrintWriter(buffer);
            Formatting.renderErrors(printer, e.getErrors());
            this.setResult(Response.error(buffer.toString()).result());
            return;
        }
        super.invoke();
    }

    String getAssetURL(Asset asset) {
        String url;
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                StringBuilder sb = new StringBuilder();
                if (!uri.startsWith("/")) {
                    sb.append(((RenderRequest)this.req).getContextPath());
                    sb.append('/');
                }
                sb.append(uri);
                url = sb.toString();
                break;
            }
            case APPLICATION: {
                if (this.bridge.getRunMode().isStatic()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((RenderRequest)this.req).getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(uri);
                    url = sb.toString();
                    break;
                }
                ResourceURL r = ((RenderResponse)this.resp).createResourceURL();
                r.setParameter("juzu.request", "assets");
                r.setResourceID(uri);
                url = r.toString();
                break;
            }
            case URL: {
                url = uri;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return url;
    }
}

