/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.bind.DatatypeConverter;
import juzu.impl.bridge.Parameters;
import juzu.io.UndeclaredIOException;
import juzu.request.ResponseParameter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO_8859_2 = Charset.forName("ISO-8859-2");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    public static final Comparator<Completion> COMPLETION_COMPARATOR = new Comparator<Completion>(){

        @Override
        public int compare(Completion o1, Completion o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };
    private static final Iterable EMPTY_ITERABLE = new Iterable(){

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }
    };
    public static Pattern EMPTY_NO_RECURSE = Pattern.compile("");
    public static Pattern EMPTY_RECURSE = Pattern.compile(".*");
    private static final String[][] HTML_ESCAPES = new String[256][];
    private static final char[] HEX;
    private static final int[] MASKS_AND_SHIFTS;

    public static Pattern getPackageMatcher(String packageName, boolean recurse) {
        if (packageName.length() == 0) {
            return recurse ? EMPTY_RECURSE : EMPTY_NO_RECURSE;
        }
        String regex = recurse ? Pattern.quote(packageName) + "(\\..*)?" : Pattern.quote(packageName);
        return Pattern.compile(regex);
    }

    public static String parentPackageOf(String pkgName) {
        int index = pkgName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return pkgName.substring(0, index);
    }

    public static Class<?> getPackageClass(ClassLoader loader, String pkgName) {
        try {
            return loader.loadClass(pkgName + ".package-info");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void escape(CharSequence s, StringBuilder appendable) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\'') {
                appendable.append("\\'");
                continue;
            }
            if (c == '\r') continue;
            appendable.append(c);
        }
    }

    public static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeFlush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Method safeGetMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <E> void addAll(Collection<? super E> collection, Iterable<E> elements) {
        for (E element : elements) {
            collection.add(element);
        }
    }

    public static <T> List<T> safeUnmodifiableList(T ... list) {
        return Tools.safeUnmodifiableList(Arrays.asList(list));
    }

    public static <T> List<T> safeUnmodifiableList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(InputStream in) throws IOException {
        byte[] byArray;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(in.available());
            Tools.copy(in, baos);
            byArray = baos.toByteArray();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return byArray;
    }

    public static void write(String content, File f) throws IOException {
        Tools.write(content.getBytes(), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] content, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Tools.copy(new ByteArrayInputStream(content), out);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
    }

    public static Map<String, String> responseHeaders(HttpURLConnection conn) {
        Map<String, String> headers = Collections.emptyMap();
        int i = 0;
        while (true) {
            String name = conn.getHeaderFieldKey(i);
            String value = conn.getHeaderField(i);
            if (name == null && value == null) break;
            if (name != null) {
                if (headers.isEmpty()) {
                    headers = new HashMap<String, String>();
                }
                headers.put(name, value);
            }
            ++i;
        }
        return headers;
    }

    public static String read(URL url) throws IOException {
        return Tools.read(url.openStream());
    }

    public static String read(File f) throws IOException {
        return Tools.read(new FileInputStream(f));
    }

    public static String read(InputStream in) throws IOException {
        return Tools.read(in, UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, Charset charset) throws IOException {
        String string;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tools.copy(in, baos);
            string = new String(baos.toByteArray(), charset);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return string;
    }

    public static <O extends OutputStream> O copy(InputStream in, O out) throws IOException {
        int l;
        byte[] buffer = new byte[256];
        while ((l = in.read(buffer)) != -1) {
            out.write(buffer, 0, l);
        }
        return out;
    }

    public static String unquote(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("Can't unquote null string");
        }
        if (s.length() > 1) {
            char c1 = s.charAt(0);
            char c2 = s.charAt(s.length() - 1);
            if ((c1 == '\'' || c1 == '\"') && c1 == c2) {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    public static String join(char separator, String ... names) {
        return Tools.join(separator, names, 0, names.length);
    }

    public static String join(char separator, String[] names, int from, int end) {
        int length = 0;
        for (int i = from; i < end; ++i) {
            if (i > from) {
                ++length;
            }
            length += names[i].length();
        }
        return Tools.join(new StringBuilder(length), separator, names, from, end).toString();
    }

    public static String join(char separator, Iterator<String> names) {
        return Tools.join(new StringBuilder(), separator, names).toString();
    }

    public static String join(char separator, Iterable<String> names) {
        return Tools.join(separator, names.iterator());
    }

    public static StringBuilder join(StringBuilder sb, char separator, String ... names) {
        return Tools.join(sb, separator, names, 0, names.length);
    }

    public static StringBuilder join(StringBuilder sb, char separator, String[] names, int from, int end) {
        try {
            Tools.join(sb, separator, names, from, end);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static StringBuilder join(StringBuilder sb, char separator, Iterator<String> names) {
        try {
            Tools.join(sb, separator, names);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static StringBuilder join(StringBuilder sb, char separator, Iterable<String> names) {
        try {
            Tools.join(sb, separator, names);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, String ... names) throws IOException {
        return Tools.join(appendable, separator, names, 0, names.length);
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, String[] names, int from, int end) throws IOException {
        int length = end - from;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                appendable.append(names[from]);
                break;
            }
            default: {
                for (int i = from; i < end; ++i) {
                    if (i > from) {
                        appendable.append(separator);
                    }
                    appendable.append(names[i]);
                }
            }
        }
        return appendable;
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, Iterable<String> names) throws IOException {
        return Tools.join(appendable, separator, names.iterator());
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, Iterator<String> names) throws IOException {
        if (names.hasNext()) {
            appendable.append(names.next());
            while (names.hasNext()) {
                appendable.append(separator);
                appendable.append(names.next());
            }
        }
        return appendable;
    }

    public static <A extends Appendable> A nameOf(Class<?> clazz, A appendable) throws IOException {
        if (clazz.isMemberClass()) {
            Tools.nameOf(clazz.getEnclosingClass(), appendable).append('.').append(clazz.getSimpleName());
        } else {
            appendable.append(clazz.getSimpleName());
        }
        return appendable;
    }

    public static String getName(Class<?> clazz) {
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Cannot use local or anonymous class");
        }
        try {
            return Tools.nameOf(clazz, new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getImport(Class<?> clazz) {
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Cannot use local or anonymous class");
        }
        if (clazz.isMemberClass()) {
            StringBuilder sb = new StringBuilder();
            while (clazz.isMemberClass()) {
                sb.insert(0, clazz.getSimpleName());
                sb.insert(0, '.');
                clazz = clazz.getEnclosingClass();
            }
            sb.insert(0, clazz.getSimpleName());
            String pkg = clazz.getPackage().getName();
            if (pkg.length() > 0) {
                sb.insert(0, '.');
                sb.insert(0, pkg);
            }
            return sb.toString();
        }
        return clazz.getName();
    }

    public static <E> HashSet<E> addToHashSet(Set<E> set, E e) {
        HashSet<E> hashSet = set instanceof HashSet ? (HashSet<E>)set : new HashSet<E>(set);
        hashSet.add(e);
        return hashSet;
    }

    public static <E> ArrayList<E> addToArrayList(List<E> list, E e) {
        ArrayList<E> arrayList = list instanceof ArrayList ? (ArrayList<E>)list : new ArrayList<E>(list);
        arrayList.add(e);
        return arrayList;
    }

    public static <E> HashSet<E> set() {
        return new HashSet();
    }

    public static <E> HashSet<E> set(E element) {
        HashSet<E> set = new HashSet<E>();
        set.add(element);
        return set;
    }

    public static <E> HashSet<E> set(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> set(Iterable<E> elements) {
        return Tools.set(elements.iterator());
    }

    public static <E> HashSet<E> set(Iterator<E> elements) {
        HashSet<E> list = new HashSet<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> HashSet<E> set(Enumeration<E> elements) {
        HashSet<E> list = new HashSet<E>();
        while (elements.hasMoreElements()) {
            list.add(elements.nextElement());
        }
        return list;
    }

    public static <E> ArrayList<E> list(Iterable<E> elements) {
        return Tools.list(elements.iterator());
    }

    public static <E> ArrayList<E> list(Iterator<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(Enumeration<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasMoreElements()) {
            list.add(elements.nextElement());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... elements) {
        ArrayList set = new ArrayList(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> elements) throws NullPointerException {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Tools.iterator(elements);
            }
        };
    }

    public static <E> Iterator<E> iterator(final Enumeration<E> elements) throws NullPointerException {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return elements.hasMoreElements();
            }

            @Override
            public E next() {
                return elements.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read only");
            }
        };
    }

    public static <E> Iterable<E> iterable(final E element) throws NullPointerException {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Tools.iterator(element);
            }
        };
    }

    public static <E> Iterator<E> iterator(final E element) throws NullPointerException {
        return new Iterator<E>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return element;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterable<E> iterable(E ... elements) throws NullPointerException {
        return new IterableArray<E>(elements, 0, elements.length);
    }

    public static <E> Iterator<E> iterator(E ... elements) throws NullPointerException {
        return new ArrayIterator<E>(elements, elements.length, 0);
    }

    public static <E> IterableArray<E> iterable(E[] elements, int from, int to) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
        return new IterableArray<E>(elements, from, to);
    }

    public static <E> Iterator<E> iterator(int from, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new ArrayIterator<E>(elements, elements.length, from);
    }

    public static <E> Iterable<E> iterable(int from, int to, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new IterableArray<E>(elements, from, to);
    }

    public static <E> Iterator<E> iterator(int from, int to, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new ArrayIterator<E>(elements, to, from);
    }

    public static <E> Iterator<E> emptyIterator() {
        Iterator iterator = EMPTY_ITERATOR;
        return iterator;
    }

    public static <E> Iterable<E> emptyIterable() {
        Iterable iterable = EMPTY_ITERABLE;
        return iterable;
    }

    public static <E> Iterator<E> append(final Iterator<E> iterator, final E ... elements) {
        return new Iterator<E>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return true;
                    }
                    this.index = 0;
                }
                return this.index < elements.length;
            }

            @Override
            public E next() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    this.index = 0;
                }
                if (this.index < elements.length) {
                    return elements[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> E[] appendTo(E[] array, E o) throws IllegalArgumentException, ClassCastException {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        Class<?> componentType = array.getClass().getComponentType();
        if (o != null && !componentType.isAssignableFrom(o.getClass())) {
            throw new ClassCastException("Object with class " + o.getClass().getName() + " cannot be casted to class " + componentType.getName());
        }
        Object[] copy = (Object[])Array.newInstance(componentType, array.length + 1);
        System.arraycopy(array, 0, copy, 0, array.length);
        copy[array.length] = o;
        return copy;
    }

    public static <S extends Serializable> S unserialize(Class<S> expectedType, File f) throws IOException, ClassNotFoundException {
        return (S)((Serializable)Tools.unserialize(expectedType, new FileInputStream(f)));
    }

    public static <S> S unserialize(Class<S> expectedType, InputStream in) throws IOException, ClassNotFoundException {
        return Tools.unserialize(null, expectedType, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S unserialize(final ClassLoader loader, Class<S> expectedType, InputStream in) throws IOException, ClassNotFoundException {
        S s;
        try {
            ObjectInputStream ois = new ObjectInputStream(in){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (loader != null) {
                        return Class.forName(desc.getName(), true, loader);
                    }
                    return super.resolveClass(desc);
                }
            };
            Object o = ois.readObject();
            s = expectedType.cast(o);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return s;
    }

    public static <S extends Serializable> void serialize(S value, File f) throws IOException {
        Tools.serialize(value, new FileOutputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void serialize(T value, OutputStream out) throws IOException {
        ObjectOutputStream ois = new ObjectOutputStream(out);
        try {
            ois.writeObject(value);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
    }

    public static <T extends Serializable> T clone(T value) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Tools.serialize(value, baos);
        byte[] bytes = baos.toByteArray();
        return (T)((Serializable)Tools.unserialize(Object.class, new ByteArrayInputStream(bytes)));
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static long parseISO8601(String date) {
        return DatatypeConverter.parseDateTime((String)date).getTimeInMillis();
    }

    public static String formatISO8601(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public static long handle(javax.lang.model.element.Element te) {
        long hash = 0L;
        for (javax.lang.model.element.Element element : te.getEnclosedElements()) {
            hash = 31L * hash + Tools.handle(element);
        }
        hash = 31L * hash + (long)te.getSimpleName().toString().hashCode();
        return hash;
    }

    public static int indexOf(CharSequence s, char c, int from) {
        return Tools.indexOf(s, c, from, s.length());
    }

    public static int indexOf(CharSequence s, char c, int from, int end) {
        if (from < end) {
            if (from < 0) {
                from = 0;
            }
            while (from < end) {
                if (s.charAt(from) == c) {
                    return from;
                }
                ++from;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char c) {
        return Tools.lastIndexOf(s, c, s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char c, int from) {
        for (from = Math.min(from, s.length() - 1); from >= 0; --from) {
            if (s.charAt(from) != c) continue;
            return from;
        }
        return -1;
    }

    public static int count(String s, String separator) {
        int pos;
        if (separator.length() == 0) {
            return s.length() + 1;
        }
        int count = 0;
        int prev = 0;
        while ((pos = s.indexOf(separator, prev)) != -1) {
            ++count;
            prev = pos + separator.length();
        }
        return count;
    }

    public static String[] split(CharSequence s, char separator) {
        return Tools.foo(s, separator, 0, 0, 0);
    }

    public static String[] split(CharSequence s, char separator, int rightPadding) {
        if (rightPadding < 0) {
            throw new IllegalArgumentException("Right padding cannot be negative");
        }
        return Tools.foo(s, separator, 0, 0, rightPadding);
    }

    private static String[] foo(CharSequence s, char separator, int count, int from, int rightPadding) {
        int len = s.length();
        if (from < len) {
            String[] ret;
            int to;
            for (to = from; to < len && s.charAt(to) != separator; ++to) {
            }
            if (to == len - 1) {
                ret = new String[count + 2 + rightPadding];
                ret[count + 1] = "";
            } else {
                ret = to == len ? new String[count + 1 + rightPadding] : Tools.foo(s, separator, count + 1, to + 1, rightPadding);
            }
            ret[count] = from == to ? "" : s.subSequence(from, to).toString();
            return ret;
        }
        if (from == len) {
            return new String[count + rightPadding];
        }
        throw new AssertionError();
    }

    public static AnnotationMirror getAnnotation(javax.lang.model.element.Element element, String annotationFQN) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationFQN)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static StringBuilder toString(Iterable<Map.Entry<String, String[]>> entries, StringBuilder sb) {
        sb.append('{');
        Iterator<Map.Entry<String, String[]>> i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry<String, String[]> entry = i.next();
            sb.append(entry.getKey()).append("=[");
            String[] value = entry.getValue();
            for (int j = 0; j < value.length; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(value[j]);
            }
            sb.append(']');
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb;
    }

    public static String nextUUID() {
        return UUID.randomUUID().toString();
    }

    public static HashMap<String, String[]> toHashMap(Parameters parameters) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (ResponseParameter parameter : parameters.values()) {
            map.put(parameter.getName(), parameter.toArray());
        }
        return map;
    }

    public static BigInteger bitSet(CharSequence s) {
        BigInteger current = BigInteger.ZERO;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            current = current.setBit(c);
        }
        return current;
    }

    public static BigInteger bitSet(char ... chars) {
        BigInteger current = BigInteger.ZERO;
        for (char c : chars) {
            current = current.setBit(c);
        }
        return current;
    }

    public static String[] safeConcat(String[] first, String[] second) {
        if (first != null) {
            if (second != null) {
                String[] concat = new String[first.length + second.length];
                System.arraycopy(first, 0, concat, 0, first.length);
                System.arraycopy(second, 0, concat, first.length, second.length);
                return concat;
            }
            return first;
        }
        if (second != null) {
            return second;
        }
        return EMPTY_STRING_ARRAY;
    }

    public static Throwable safeCause(Throwable throwable) throws NullPointerException {
        Throwable cause = throwable.getCause();
        return cause != null ? cause : throwable;
    }

    private static void addNamedHtmlEntity(int c, String entity) {
        Tools.addHtmlEscape(c, "&" + entity + ";");
    }

    private static void addHtmlEscape(int c, String entity) {
        int i1 = c >> 8;
        String[] table = HTML_ESCAPES[i1];
        if (table == null) {
            table = new String[256];
            Tools.HTML_ESCAPES[i1] = table;
        }
        table[c & 0xFF] = entity;
    }

    public static String getHtmlEscape(char c) {
        int lookup = c >> 8;
        if (lookup < 256) {
            String[] table = HTML_ESCAPES[lookup];
            int pointer = c & 0xFF;
            return table[pointer];
        }
        return null;
    }

    public static void encodeHtmlText(CharSequence src, int from, int end, Appendable dst) throws IOException, IllegalArgumentException {
        Tools.encodeHtml(src, from, end, dst);
    }

    public static void encodeHtmlAttribute(CharSequence src, int from, int end, Appendable dst) throws IOException, IllegalArgumentException {
        Tools.encodeHtml(src, from, end, dst);
    }

    private static void encodeHtml(CharSequence src, int from, int to, Appendable dst) throws IOException, IllegalArgumentException {
        if (from < 0) {
            throw new IllegalArgumentException("From bound cannot be negative");
        }
        if (to > src.length()) {
            throw new IllegalArgumentException("To bound cannot be greater than source length");
        }
        if (from > to) {
            throw new IllegalArgumentException("From bound cannot be greater than to bound");
        }
        while (from < to) {
            char c;
            String escape;
            if ((escape = Tools.getHtmlEscape(c = src.charAt(from++))) != null) {
                dst.append(escape);
                continue;
            }
            dst.append(c);
        }
    }

    public static <A extends Appendable> A toHex(int value, A appendable) throws IOException {
        boolean foo = false;
        for (int i = 0; i < MASKS_AND_SHIFTS.length; i += 2) {
            int tmp = value & MASKS_AND_SHIFTS[i];
            if (tmp != 0) {
                char cc = HEX[tmp >>>= MASKS_AND_SHIFTS[i + 1]];
                appendable.append(cc);
                foo = true;
                continue;
            }
            if (!foo && i != MASKS_AND_SHIFTS.length - 2) continue;
            appendable.append("0");
        }
        return appendable;
    }

    public static <A extends Appendable> A encodeHtml(Element element, A dst) throws IOException {
        Node child;
        int i;
        int length;
        NodeList children;
        boolean empty;
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("script")) {
            empty = false;
        } else {
            empty = true;
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length && empty; ++i) {
                child = children.item(i);
                if (child instanceof CharacterData) {
                    empty = false;
                    continue;
                }
                if (!(child instanceof Element)) continue;
                empty = false;
            }
        }
        dst.append('<');
        dst.append(tagName);
        if (element.hasAttributes()) {
            NamedNodeMap attrs = element.getAttributes();
            length = attrs.getLength();
            for (i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                dst.append(' ');
                dst.append(attr.getName());
                dst.append("=\"");
                Tools.encodeHtmlAttribute(attr.getValue(), 0, attr.getValue().length(), dst);
                dst.append("\"");
            }
        }
        if (!empty) {
            dst.append(">");
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length; ++i) {
                child = children.item(i);
                if (child instanceof CDATASection) {
                    throw new UnsupportedOperationException("Encoding CDATA not yet supported");
                }
                if (child instanceof CharacterData) {
                    String data = ((CharacterData)child).getData();
                    Tools.encodeHtmlText(data, 0, data.length(), dst);
                    continue;
                }
                if (!(child instanceof Element)) continue;
                Tools.encodeHtml((Element)child, dst);
            }
            dst.append("</").append(tagName).append('>');
        } else {
            dst.append("/>");
        }
        return dst;
    }

    public static Iterable<Node> children(final Node node) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int i = 0;
                    NodeList children;
                    {
                        this.children = node.getChildNodes();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.children.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return this.children.item(this.i++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static {
        Tools.addNamedHtmlEntity(160, "nbsp");
        Tools.addNamedHtmlEntity(161, "iexcl");
        Tools.addNamedHtmlEntity(162, "cent");
        Tools.addNamedHtmlEntity(163, "pound");
        Tools.addNamedHtmlEntity(164, "curren");
        Tools.addNamedHtmlEntity(165, "yen");
        Tools.addNamedHtmlEntity(166, "brvbar");
        Tools.addNamedHtmlEntity(167, "sect");
        Tools.addNamedHtmlEntity(168, "uml");
        Tools.addNamedHtmlEntity(169, "copy");
        Tools.addNamedHtmlEntity(170, "ordf");
        Tools.addNamedHtmlEntity(171, "laquo");
        Tools.addNamedHtmlEntity(172, "not");
        Tools.addNamedHtmlEntity(173, "shy");
        Tools.addNamedHtmlEntity(174, "reg");
        Tools.addNamedHtmlEntity(175, "macr");
        Tools.addNamedHtmlEntity(176, "deg");
        Tools.addNamedHtmlEntity(177, "plusmn");
        Tools.addNamedHtmlEntity(178, "sup2");
        Tools.addNamedHtmlEntity(179, "sup3");
        Tools.addNamedHtmlEntity(180, "acute");
        Tools.addNamedHtmlEntity(181, "micro");
        Tools.addNamedHtmlEntity(182, "para");
        Tools.addNamedHtmlEntity(183, "middot");
        Tools.addNamedHtmlEntity(184, "cedil");
        Tools.addNamedHtmlEntity(185, "sup1");
        Tools.addNamedHtmlEntity(186, "ordm");
        Tools.addNamedHtmlEntity(187, "raquo");
        Tools.addNamedHtmlEntity(188, "frac14");
        Tools.addNamedHtmlEntity(189, "frac12");
        Tools.addNamedHtmlEntity(190, "frac34");
        Tools.addNamedHtmlEntity(191, "iquest");
        Tools.addNamedHtmlEntity(192, "Agrave");
        Tools.addNamedHtmlEntity(193, "Aacute");
        Tools.addNamedHtmlEntity(194, "Acirc");
        Tools.addNamedHtmlEntity(195, "Atilde");
        Tools.addNamedHtmlEntity(196, "Auml");
        Tools.addNamedHtmlEntity(197, "Aring");
        Tools.addNamedHtmlEntity(198, "AElig");
        Tools.addNamedHtmlEntity(199, "Ccedil");
        Tools.addNamedHtmlEntity(200, "Egrave");
        Tools.addNamedHtmlEntity(201, "Eacute");
        Tools.addNamedHtmlEntity(202, "Ecirc");
        Tools.addNamedHtmlEntity(203, "Euml");
        Tools.addNamedHtmlEntity(204, "Igrave");
        Tools.addNamedHtmlEntity(205, "Iacute");
        Tools.addNamedHtmlEntity(206, "Icirc");
        Tools.addNamedHtmlEntity(207, "Iuml");
        Tools.addNamedHtmlEntity(208, "ETH");
        Tools.addNamedHtmlEntity(209, "Ntilde");
        Tools.addNamedHtmlEntity(210, "Ograve");
        Tools.addNamedHtmlEntity(211, "Oacute");
        Tools.addNamedHtmlEntity(212, "Ocirc");
        Tools.addNamedHtmlEntity(213, "Otilde");
        Tools.addNamedHtmlEntity(214, "Ouml");
        Tools.addNamedHtmlEntity(215, "times");
        Tools.addNamedHtmlEntity(216, "Oslash");
        Tools.addNamedHtmlEntity(217, "Ugrave");
        Tools.addNamedHtmlEntity(218, "Uacute");
        Tools.addNamedHtmlEntity(219, "Ucirc");
        Tools.addNamedHtmlEntity(220, "Uuml");
        Tools.addNamedHtmlEntity(221, "Yacute");
        Tools.addNamedHtmlEntity(222, "THORN");
        Tools.addNamedHtmlEntity(223, "szlig");
        Tools.addNamedHtmlEntity(224, "agrave");
        Tools.addNamedHtmlEntity(225, "aacute");
        Tools.addNamedHtmlEntity(226, "acirc");
        Tools.addNamedHtmlEntity(227, "atilde");
        Tools.addNamedHtmlEntity(228, "auml");
        Tools.addNamedHtmlEntity(229, "aring");
        Tools.addNamedHtmlEntity(230, "aelig");
        Tools.addNamedHtmlEntity(231, "ccedil");
        Tools.addNamedHtmlEntity(232, "egrave");
        Tools.addNamedHtmlEntity(233, "eacute");
        Tools.addNamedHtmlEntity(234, "ecirc");
        Tools.addNamedHtmlEntity(235, "euml");
        Tools.addNamedHtmlEntity(236, "igrave");
        Tools.addNamedHtmlEntity(237, "iacute");
        Tools.addNamedHtmlEntity(238, "icirc");
        Tools.addNamedHtmlEntity(239, "iuml");
        Tools.addNamedHtmlEntity(240, "eth");
        Tools.addNamedHtmlEntity(241, "ntilde");
        Tools.addNamedHtmlEntity(242, "ograve");
        Tools.addNamedHtmlEntity(243, "oacute");
        Tools.addNamedHtmlEntity(244, "ocirc");
        Tools.addNamedHtmlEntity(245, "otilde");
        Tools.addNamedHtmlEntity(246, "ouml");
        Tools.addNamedHtmlEntity(247, "divide");
        Tools.addNamedHtmlEntity(248, "oslash");
        Tools.addNamedHtmlEntity(249, "ugrave");
        Tools.addNamedHtmlEntity(250, "uacute");
        Tools.addNamedHtmlEntity(251, "ucirc");
        Tools.addNamedHtmlEntity(252, "uuml");
        Tools.addNamedHtmlEntity(253, "yacute");
        Tools.addNamedHtmlEntity(254, "thorn");
        Tools.addNamedHtmlEntity(255, "yuml");
        Tools.addNamedHtmlEntity(402, "fnof");
        Tools.addNamedHtmlEntity(913, "Alpha");
        Tools.addNamedHtmlEntity(914, "Beta");
        Tools.addNamedHtmlEntity(915, "Gamma");
        Tools.addNamedHtmlEntity(916, "Delta");
        Tools.addNamedHtmlEntity(917, "Epsilon");
        Tools.addNamedHtmlEntity(918, "Zeta");
        Tools.addNamedHtmlEntity(919, "Eta");
        Tools.addNamedHtmlEntity(920, "Theta");
        Tools.addNamedHtmlEntity(921, "Iota");
        Tools.addNamedHtmlEntity(922, "Kappa");
        Tools.addNamedHtmlEntity(923, "Lambda");
        Tools.addNamedHtmlEntity(924, "Mu");
        Tools.addNamedHtmlEntity(925, "Nu");
        Tools.addNamedHtmlEntity(926, "Xi");
        Tools.addNamedHtmlEntity(927, "Omicron");
        Tools.addNamedHtmlEntity(928, "Pi");
        Tools.addNamedHtmlEntity(929, "Rho");
        Tools.addNamedHtmlEntity(931, "Sigma");
        Tools.addNamedHtmlEntity(932, "Tau");
        Tools.addNamedHtmlEntity(933, "Upsilon");
        Tools.addNamedHtmlEntity(934, "Phi");
        Tools.addNamedHtmlEntity(935, "Chi");
        Tools.addNamedHtmlEntity(936, "Psi");
        Tools.addNamedHtmlEntity(937, "Omega");
        Tools.addNamedHtmlEntity(945, "alpha");
        Tools.addNamedHtmlEntity(946, "beta");
        Tools.addNamedHtmlEntity(947, "gamma");
        Tools.addNamedHtmlEntity(948, "delta");
        Tools.addNamedHtmlEntity(949, "epsilon");
        Tools.addNamedHtmlEntity(950, "zeta");
        Tools.addNamedHtmlEntity(951, "eta");
        Tools.addNamedHtmlEntity(952, "theta");
        Tools.addNamedHtmlEntity(953, "iota");
        Tools.addNamedHtmlEntity(954, "kappa");
        Tools.addNamedHtmlEntity(955, "lambda");
        Tools.addNamedHtmlEntity(956, "mu");
        Tools.addNamedHtmlEntity(957, "nu");
        Tools.addNamedHtmlEntity(958, "xi");
        Tools.addNamedHtmlEntity(959, "omicron");
        Tools.addNamedHtmlEntity(960, "pi");
        Tools.addNamedHtmlEntity(961, "rho");
        Tools.addNamedHtmlEntity(962, "sigmaf");
        Tools.addNamedHtmlEntity(963, "sigma");
        Tools.addNamedHtmlEntity(964, "tau");
        Tools.addNamedHtmlEntity(965, "upsilon");
        Tools.addNamedHtmlEntity(966, "phi");
        Tools.addNamedHtmlEntity(967, "chi");
        Tools.addNamedHtmlEntity(968, "psi");
        Tools.addNamedHtmlEntity(969, "omega");
        Tools.addNamedHtmlEntity(977, "thetasym");
        Tools.addNamedHtmlEntity(978, "upsih");
        Tools.addNamedHtmlEntity(982, "piv");
        Tools.addNamedHtmlEntity(8226, "bull");
        Tools.addNamedHtmlEntity(8230, "hellip");
        Tools.addNamedHtmlEntity(8242, "prime");
        Tools.addNamedHtmlEntity(8243, "Prime");
        Tools.addNamedHtmlEntity(8254, "oline");
        Tools.addNamedHtmlEntity(8260, "frasl");
        Tools.addNamedHtmlEntity(8472, "weierp");
        Tools.addNamedHtmlEntity(8465, "image");
        Tools.addNamedHtmlEntity(8476, "real");
        Tools.addNamedHtmlEntity(8482, "trade");
        Tools.addNamedHtmlEntity(8501, "alefsym");
        Tools.addNamedHtmlEntity(8592, "larr");
        Tools.addNamedHtmlEntity(8593, "uarr");
        Tools.addNamedHtmlEntity(8594, "rarr");
        Tools.addNamedHtmlEntity(8595, "darr");
        Tools.addNamedHtmlEntity(8596, "harr");
        Tools.addNamedHtmlEntity(8629, "crarr");
        Tools.addNamedHtmlEntity(8656, "lArr");
        Tools.addNamedHtmlEntity(8657, "uArr");
        Tools.addNamedHtmlEntity(8658, "rArr");
        Tools.addNamedHtmlEntity(8659, "dArr");
        Tools.addNamedHtmlEntity(8660, "hArr");
        Tools.addNamedHtmlEntity(8704, "forall");
        Tools.addNamedHtmlEntity(8706, "part");
        Tools.addNamedHtmlEntity(8707, "exist");
        Tools.addNamedHtmlEntity(8709, "empty");
        Tools.addNamedHtmlEntity(8711, "nabla");
        Tools.addNamedHtmlEntity(8712, "isin");
        Tools.addNamedHtmlEntity(8713, "notin");
        Tools.addNamedHtmlEntity(8715, "ni");
        Tools.addNamedHtmlEntity(8719, "prod");
        Tools.addNamedHtmlEntity(8721, "sum");
        Tools.addNamedHtmlEntity(8722, "minus");
        Tools.addNamedHtmlEntity(8727, "lowast");
        Tools.addNamedHtmlEntity(8730, "radic");
        Tools.addNamedHtmlEntity(8733, "prop");
        Tools.addNamedHtmlEntity(8734, "infin");
        Tools.addNamedHtmlEntity(8736, "ang");
        Tools.addNamedHtmlEntity(8743, "and");
        Tools.addNamedHtmlEntity(8744, "or");
        Tools.addNamedHtmlEntity(8745, "cap");
        Tools.addNamedHtmlEntity(8746, "cup");
        Tools.addNamedHtmlEntity(8747, "int");
        Tools.addNamedHtmlEntity(8756, "there4");
        Tools.addNamedHtmlEntity(8764, "sim");
        Tools.addNamedHtmlEntity(8773, "cong");
        Tools.addNamedHtmlEntity(8776, "asymp");
        Tools.addNamedHtmlEntity(8800, "ne");
        Tools.addNamedHtmlEntity(8801, "equiv");
        Tools.addNamedHtmlEntity(8804, "le");
        Tools.addNamedHtmlEntity(8805, "ge");
        Tools.addNamedHtmlEntity(8834, "sub");
        Tools.addNamedHtmlEntity(8835, "sup");
        Tools.addNamedHtmlEntity(8836, "nsub");
        Tools.addNamedHtmlEntity(8838, "sube");
        Tools.addNamedHtmlEntity(8839, "supe");
        Tools.addNamedHtmlEntity(8853, "oplus");
        Tools.addNamedHtmlEntity(8855, "otimes");
        Tools.addNamedHtmlEntity(8869, "perp");
        Tools.addNamedHtmlEntity(8901, "sdot");
        Tools.addNamedHtmlEntity(8968, "lceil");
        Tools.addNamedHtmlEntity(8969, "rceil");
        Tools.addNamedHtmlEntity(8970, "lfloor");
        Tools.addNamedHtmlEntity(8971, "rfloor");
        Tools.addNamedHtmlEntity(9001, "lang");
        Tools.addNamedHtmlEntity(9002, "rang");
        Tools.addNamedHtmlEntity(9674, "loz");
        Tools.addNamedHtmlEntity(9824, "spades");
        Tools.addNamedHtmlEntity(9827, "clubs");
        Tools.addNamedHtmlEntity(9829, "hearts");
        Tools.addNamedHtmlEntity(9830, "diams");
        Tools.addNamedHtmlEntity(34, "quot");
        Tools.addNamedHtmlEntity(38, "amp");
        Tools.addNamedHtmlEntity(60, "lt");
        Tools.addNamedHtmlEntity(62, "gt");
        Tools.addNamedHtmlEntity(338, "OElig");
        Tools.addNamedHtmlEntity(339, "oelig");
        Tools.addNamedHtmlEntity(352, "Scaron");
        Tools.addNamedHtmlEntity(353, "scaron");
        Tools.addNamedHtmlEntity(376, "Yuml");
        Tools.addNamedHtmlEntity(710, "circ");
        Tools.addNamedHtmlEntity(732, "tilde");
        Tools.addNamedHtmlEntity(8194, "ensp");
        Tools.addNamedHtmlEntity(8195, "emsp");
        Tools.addNamedHtmlEntity(8201, "thinsp");
        Tools.addNamedHtmlEntity(8204, "zwnj");
        Tools.addNamedHtmlEntity(8205, "zwj");
        Tools.addNamedHtmlEntity(8206, "lrm");
        Tools.addNamedHtmlEntity(8207, "rlm");
        Tools.addNamedHtmlEntity(8211, "ndash");
        Tools.addNamedHtmlEntity(8212, "mdash");
        Tools.addNamedHtmlEntity(8216, "lsquo");
        Tools.addNamedHtmlEntity(8217, "rsquo");
        Tools.addNamedHtmlEntity(8218, "sbquo");
        Tools.addNamedHtmlEntity(8220, "ldquo");
        Tools.addNamedHtmlEntity(8221, "rdquo");
        Tools.addNamedHtmlEntity(8222, "bdquo");
        Tools.addNamedHtmlEntity(8224, "dagger");
        Tools.addNamedHtmlEntity(8225, "Dagger");
        Tools.addNamedHtmlEntity(8240, "permil");
        Tools.addNamedHtmlEntity(8249, "lsaquo");
        Tools.addNamedHtmlEntity(8250, "rsaquo");
        Tools.addNamedHtmlEntity(8364, "euro");
        HEX = "0123456789abcdef".toCharArray();
        MASKS_AND_SHIFTS = new int[]{-268435456, 28, 0xF000000, 24, 0xF00000, 20, 983040, 16, 61440, 12, 3840, 8, 240, 4, 15, 0};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IterableArray<E>
    implements Iterable<E> {
        private final E[] elements;
        private final int from;
        private final int to;

        IterableArray(E[] elements, int from, int to) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
            if (elements == null) {
                throw new NullPointerException("No null elements accepted");
            }
            if (from < 0) {
                throw new IndexOutOfBoundsException("From index cannot be negative");
            }
            if (to > elements.length + 1) {
                throw new IndexOutOfBoundsException("To index cannot be greater than the array size + 1");
            }
            if (from > to) {
                throw new IllegalArgumentException("From index cannot be greater than the to index");
            }
            this.elements = elements;
            this.from = from;
            this.to = to;
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator<E>(this.elements, this.to, this.from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] elements;
        private final int to;
        private int current;

        ArrayIterator(E[] elements, int to, int current) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
            if (elements == null) {
                throw new NullPointerException("No null elements accepted");
            }
            if (current < 0) {
                throw new IndexOutOfBoundsException("From index cannot be negative");
            }
            if (to > elements.length + 1) {
                throw new IndexOutOfBoundsException("To index cannot be greater than the array size + 1");
            }
            if (current > to) {
                throw new IllegalArgumentException("From index cannot be greater than the to index");
            }
            this.elements = elements;
            this.current = current;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.to;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.current++];
        }

        @Override
        public void remove() {
            throw new NoSuchElementException();
        }
    }
}

