/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import juzu.impl.compiler.MessageCode;

public class Message {
    static final Pattern PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\((.*)\\)", 32);
    static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private final MessageCode code;
    private final String[] arguments;

    public static Message parse(String s) {
        List arguments = Collections.emptyList();
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            String codeKey = matcher.group(1);
            MessageCode code = MessageCode.decode(codeKey);
            if (matcher.group(2).length() > 0) {
                arguments = new ArrayList();
                for (String argument : SPLIT_PATTERN.split(matcher.group(2), 0)) {
                    int pos;
                    int prev = 0;
                    while ((pos = argument.indexOf(92, prev)) != -1) {
                        argument = argument.substring(0, pos) + argument.charAt(pos + 1) + argument.substring(pos + 2);
                        prev = pos + 2;
                    }
                    arguments.add(argument);
                }
            }
            return new Message(code, arguments.toArray());
        }
        return null;
    }

    public Message(MessageCode code, Object ... arguments) {
        String[] array = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            array[i] = String.valueOf(arguments[i]);
        }
        this.code = code;
        this.arguments = array;
    }

    public MessageCode getCode() {
        return this.code;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public StringBuilder format(StringBuilder sb, boolean formal) {
        if (formal) {
            sb = sb.append("[").append(this.code.getKey()).append("](");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                String value = String.valueOf(this.arguments[i]);
                for (int j = 0; j < value.length(); ++j) {
                    char c = value.charAt(j);
                    switch (c) {
                        case ')': 
                        case ',': 
                        case '\\': {
                            sb.append('\\');
                        }
                    }
                    sb.append(c);
                }
            }
            sb.append(")");
        } else {
            new Formatter(sb).format(Locale.getDefault(), this.code.getMessage(), (Object[])this.arguments).flush();
        }
        return sb;
    }

    public String format() {
        return this.format(new StringBuilder(), true).toString();
    }

    public String toDisplayString() {
        return this.format(new StringBuilder(), false).toString();
    }

    public String toString() {
        return this.format(new StringBuilder("CompilationMessage["), false).append("]").toString();
    }
}

