/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import juzu.Response;
import juzu.bridge.vertx.VertxRequestContext;
import juzu.bridge.vertx.VertxWebBridge;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.bridge.module.ApplicationBridge;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationException;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.resource.ClassLoaderResolver;
import juzu.impl.resource.ResourceResolver;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.impl.MimeMapping;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.deploy.Container;

public class Application {
    private final Container container;
    private final Vertx vertx;
    private final ClassLoader loader;
    private final DiskFileSystem sourcePath;
    private final Name main;
    final int port;

    Application(Container container, Vertx vertx, ClassLoader loader, DiskFileSystem sourcePath, Name main, int port) {
        this.container = container;
        this.vertx = vertx;
        this.loader = loader;
        this.sourcePath = sourcePath;
        this.main = main;
        this.port = port;
    }

    public void start() throws Exception {
        final juzu.impl.common.Logger log = new juzu.impl.common.Logger(){
            final Logger logger;
            {
                this.logger = Application.this.container.getLogger();
            }

            public void log(CharSequence msg) {
                this.logger.info((Object)msg);
            }

            public void log(CharSequence msg, Throwable t) {
                this.logger.info((Object)msg, t);
            }
        };
        HttpServer server = this.vertx.createHttpServer().requestHandler((Handler)new Handler<HttpServerRequest>(){
            juzu.impl.bridge.spi.web.Handler h;
            Bridge bridge = null;

            public void handle(final HttpServerRequest req) {
                String contentType = (String)req.headers().get("Content-Type");
                if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                    req.bodyHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer buffer) {
                            VertxRequestContext ctx = new VertxRequestContext(req, buffer, log);
                            this.handle2(ctx);
                        }
                    });
                } else {
                    VertxRequestContext ctx = new VertxRequestContext(req, null, log);
                    this.handle2(ctx);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handle2(VertxRequestContext ctx) {
                if (this.bridge == null) {
                    try {
                        ClassLoaderResolver r = new ClassLoaderResolver(Application.this.loader);
                        HashMap<String, String> cfg = new HashMap<String, String>();
                        cfg.put("juzu.inject", InjectorProvider.INJECT_GUICE.getValue());
                        cfg.put("juzu.app_name", Application.this.main.toString());
                        BridgeConfig config = new BridgeConfig(cfg);
                        BridgeContext context = new BridgeContext(){
                            final ResourceResolver resolver;
                            final HashMap<String, Object> attributes;
                            {
                                this.resolver = new ClassLoaderResolver(Application.this.loader);
                                this.attributes = new HashMap();
                            }

                            public ClassLoader getClassLoader() {
                                return Application.this.loader;
                            }

                            public String getInitParameter(String name) {
                                if ("juzu.run_mode".equals(name)) {
                                    return "live";
                                }
                                return null;
                            }

                            public ResourceResolver getResolver() {
                                return this.resolver;
                            }

                            public Object getAttribute(String key) {
                                return this.attributes.get(key);
                            }

                            public void setAttribute(String key, Object value) {
                                if (value != null) {
                                    this.attributes.put(key, value);
                                } else {
                                    this.attributes.remove(key);
                                }
                            }

                            public ReadFileSystem<?> getClassPath() {
                                throw new UnsupportedOperationException("Not supported");
                            }

                            public ReadFileSystem<?> getSourcePath() {
                                return Application.this.sourcePath;
                            }

                            public ReadFileSystem<?> getResourcePath() {
                                return Application.this.sourcePath;
                            }
                        };
                        Injector injector = config.injectorProvider.get();
                        injector.bindBean(Vertx.class, null, (Object)Application.this.vertx);
                        this.bridge = new ApplicationBridge(context, log, config, null, (ResourceResolver)r, injector);
                    }
                    catch (CompilationException e) {
                        try {
                            ctx.send(e);
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception e) {
                        try {
                            ctx.send(Response.error((Throwable)e).result(), true);
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        return;
                    }
                }
                try {
                    if (this.bridge.refresh(true)) {
                        this.h = null;
                    }
                    if (this.h == null) {
                        this.h = new juzu.impl.bridge.spi.web.Handler(this.bridge);
                    }
                }
                catch (CompilationException e) {
                    try {
                        ctx.send(e);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        ctx.send(Response.error((Throwable)e).result(), true);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return;
                }
                boolean served = false;
                HttpServerResponse response = ctx.req.response;
                Iterable resolvers = this.bridge.getApplication().resolveBeans(ResourceResolver.class);
                Iterator i = resolvers.iterator();
                while (i.hasNext() && !served) {
                    ResourceResolver resolver = (ResourceResolver)i.next();
                    URL assetURL = resolver.resolve(ctx.req.path);
                    if (assetURL == null) continue;
                    served = true;
                    if ("file".equals(assetURL.getProtocol())) {
                        try {
                            response.sendFile(new File(assetURL.toURI()).getAbsolutePath());
                            break;
                        }
                        catch (URISyntaxException ignore) {
                            continue;
                        }
                    }
                    try {
                        String ext;
                        String contentType;
                        InputStream in = assetURL.openStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Tools.copy((InputStream)in, (OutputStream)baos);
                        byte[] bytes = baos.toByteArray();
                        String filename = assetURL.getPath();
                        int li = filename.lastIndexOf(46);
                        if (li != -1 && li != filename.length() - 1 && (contentType = MimeMapping.getMimeTypeForExtension((String)(ext = filename.substring(li + 1, filename.length())))) != null) {
                            ctx.req.response.headers().put("Content-Type", contentType);
                        }
                        ctx.req.response.headers().put("Content-Length", String.valueOf(bytes.length));
                        ctx.req.response.writeBuffer(new Buffer(bytes));
                        ctx.req.response.end();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        ctx.req.response.close();
                    }
                }
                if (!served) {
                    VertxWebBridge webBridge = new VertxWebBridge(this.bridge, ctx, Application.this);
                    webBridge.handle(this.h);
                }
            }
        }).listen(this.port);
    }

    public void stop() throws Exception {
    }
}

