/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.guice;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.guice.BeanBinding;
import juzu.impl.inject.spi.guice.GuiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceInjector
extends Injector {
    final List<BeanBinding> bindings;
    final Set<Scope> scopes;
    ClassLoader classLoader;

    public GuiceInjector() {
        this.bindings = new ArrayList<BeanBinding>();
        this.scopes = new HashSet<Scope>();
    }

    public GuiceInjector(GuiceInjector that) {
        this.bindings = new ArrayList<BeanBinding>(that.bindings);
        this.scopes = new HashSet<Scope>(that.scopes);
    }

    @Override
    public boolean isProvided() {
        return false;
    }

    @Override
    public <T> Injector declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        this.bindings.add(new BeanBinding.ToType<T>(type, beanScope, qualifiers, implementationType));
        return this;
    }

    @Override
    public <T> Injector declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        this.bindings.add(new BeanBinding.ToProviderType<T>(type, beanScope, qualifiers, provider));
        return this;
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public Injector addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <T> Injector bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        this.bindings.add(new BeanBinding.ToInstance<T>(type, qualifiers, instance));
        return this;
    }

    @Override
    public <T> Injector bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<? extends T> provider) {
        this.bindings.add(new BeanBinding.ToProviderInstance<T>(beanType, beanScope, beanQualifiers, provider));
        return this;
    }

    @Override
    public InjectionContext<?, ?> create(Filter<Class<?>> filter) throws Exception {
        return new GuiceContext(this);
    }

    @Override
    public Injector get() {
        return new GuiceInjector(this);
    }
}

