/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyType;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.StreamableDecorator;
import juzu.plugin.asset.WithAssets;
import juzu.request.Phase;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPlugin
extends ApplicationPlugin
implements RequestFilter {
    private LinkedHashMap<String, Chunk.Property<String>> assets;
    private AssetDescriptor descriptor;
    private PluginContext context;
    private String assetsPath;
    @Inject
    AssetManager assetManager;

    public AssetPlugin() {
        super("asset");
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public String getAssetsPath() {
        return this.assetsPath;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        String assetsPath;
        List<AssetMetaData> assets;
        JSON config = context.getConfig();
        if (config != null) {
            String packageName = config.getString("package");
            AssetLocation location = AssetLocation.safeValueOf(config.getString("location"));
            if (location == null) {
                location = AssetLocation.APPLICATION;
            }
            assets = this.load(packageName, location, config.getList("assets", JSON.class));
            assetsPath = "/" + Name.parse(this.application.getPackageName()).append(packageName).toString().replace('.', '/') + "/";
        } else {
            assets = Collections.emptyList();
            assetsPath = null;
        }
        this.descriptor = new AssetDescriptor(assets);
        this.context = context;
        this.assetsPath = assetsPath;
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, AssetLocation defaultLocation, List<? extends JSON> scripts) throws Exception {
        List<AssetMetaData> abc = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (JSON jSON : scripts) {
                String id = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                if (location == null) {
                    location = defaultLocation;
                }
                ArrayList<String> values = new ArrayList<String>(jSON.getList("value", String.class));
                if (location == AssetLocation.APPLICATION) {
                    for (int i = 0; i < values.size(); ++i) {
                        String value = (String)values.get(i);
                        if (value.startsWith("/")) continue;
                        values.set(i, "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + value);
                    }
                }
                AssetMetaData descriptor = new AssetMetaData(id, location, values, jSON.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() throws Exception {
        this.assets = this.process(this.descriptor.getAssets());
    }

    public URL resolve(AssetLocation location, String path) {
        switch (location) {
            case APPLICATION: {
                return this.context.getApplicationResolver().resolve(path);
            }
            case SERVER: {
                return this.context.getServerResolver().resolve(path);
            }
        }
        return null;
    }

    private LinkedHashMap<String, Chunk.Property<String>> process(List<AssetMetaData> data) throws Exception {
        LinkedHashMap<String, Chunk.Property<String>> assets = new LinkedHashMap<String, Chunk.Property<String>>();
        for (AssetMetaData script : data) {
            String id;
            HashMap<String, URL> resources = new HashMap<String, URL>(script.getValues().size());
            AssetLocation location = script.getLocation();
            if (location == AssetLocation.APPLICATION) {
                for (String value : script.getValues()) {
                    URL url = this.resolve(AssetLocation.APPLICATION, value);
                    if (url == null) {
                        throw new Exception("Could not resolve application  " + value);
                    }
                    resources.put(value, url);
                }
            } else if (location == AssetLocation.SERVER) {
                for (String value : script.getValues()) {
                    URL url;
                    if (!value.startsWith("/") && (url = this.resolve(AssetLocation.SERVER, "/" + value)) == null) {
                        throw new Exception("Could not resolve server asset " + value);
                    }
                    resources.put(value, null);
                }
            } else {
                for (String value : script.getValues()) {
                    resources.put(value, null);
                }
            }
            if ((id = script.getId()) == null) {
                String value;
                value = script.getValues().get(0);
                int slash = value.lastIndexOf(47);
                id = slash >= 0 ? value.substring(slash + 1) : value;
            }
            this.assetManager.addAsset(id, script.getLocation(), resources, script.getDependencies());
            assets.put(id, new Chunk.Property<String>(id, PropertyType.ASSET));
        }
        return assets;
    }

    private Collection<Chunk.Property<String>> foo(AnnotatedElement elt, List<Chunk.Property<String>> bar) {
        WithAssets decl = elt.getAnnotation(WithAssets.class);
        if (decl != null) {
            String[] value;
            for (String s : value = decl.value()) {
                if (s.equals("*")) {
                    return this.assets.values();
                }
                Chunk.Property<String> p = this.assets.get(s);
                if (p == null) {
                    throw new UnsupportedOperationException("handle me gracefully");
                }
                if (bar.size() == 0) {
                    bar = new ArrayList<Chunk.Property<String>>();
                }
                bar.add(p);
            }
        }
        if (elt instanceof Method) {
            Method methodElt = (Method)elt;
            if (decl == null) {
                for (Class<?> current = methodElt.getDeclaringClass().getSuperclass(); current != null; current = current.getSuperclass()) {
                    try {
                        methodElt = current.getDeclaredMethod(methodElt.getName(), methodElt.getParameterTypes());
                        return this.foo(methodElt, bar);
                    }
                    catch (NoSuchMethodException ignore) {
                        continue;
                    }
                }
            }
            return this.foo(methodElt.getDeclaringClass(), bar);
        }
        if (elt instanceof Class) {
            Class classElt = (Class)elt;
            String pkgName = classElt.getSimpleName().equals("package-info") ? Tools.parentPackageOf(Tools.parentPackageOf(classElt.getName())) : Tools.parentPackageOf(classElt.getName());
            while (pkgName != null) {
                Class<?> currentPackage = Tools.getPackageClass(Thread.currentThread().getContextClassLoader(), pkgName);
                if (currentPackage != null) {
                    return this.foo(currentPackage, bar);
                }
                pkgName = Tools.parentPackageOf(pkgName);
            }
            return bar;
        }
        return bar;
    }

    @Override
    public void invoke(Request request) {
        Result result;
        request.invoke();
        if (request.getPhase() == Phase.VIEW && (result = request.getResult()) instanceof Result.Status) {
            final Collection<Chunk.Property<String>> bar = this.foo(request.getMethod().getMethod(), Collections.<Chunk.Property<String>>emptyList());
            Result.Status status = (Result.Status)result;
            if (status.decorated && bar.size() > 0) {
                status = new Result.Status(status.code, true, new StreamableDecorator(status.streamable){

                    protected void sendHeader(Stream consumer) {
                        for (Chunk.Property asset : bar) {
                            consumer.provide(asset);
                        }
                    }
                });
                request.setResult(status);
            }
        }
    }
}

