/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.runtime;

import java.io.IOException;
import java.net.URL;
import juzu.impl.common.LiveClassLoader;
import juzu.impl.common.Logger;
import juzu.impl.common.ParentJarClassLoader;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.Filter;
import juzu.impl.fs.Snapshot;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.url.URLFileSystem;
import juzu.processor.MainProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleRuntime<C> {
    protected final Logger logger;

    protected ModuleRuntime(Logger logger) {
        this.logger = logger;
    }

    public abstract boolean refresh(boolean var1) throws Exception, CompilationException;

    public abstract ClassLoader getClassLoader();

    public abstract ReadFileSystem<C> getClasses();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Static<P>
    extends ModuleRuntime<P> {
        private final ClassLoader classLoader;
        private final ReadFileSystem<P> classes;

        public Static(Logger logger, ClassLoader classLoader, ReadFileSystem<P> classes) {
            super(logger);
            this.classLoader = classLoader;
            this.classes = classes;
        }

        @Override
        public boolean refresh(boolean recompile) {
            return false;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public ReadFileSystem<P> getClasses() {
            return this.classes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dynamic<S>
    extends ModuleRuntime<String[]> {
        private final ClassLoader baseClassLoader;
        private URLFileSystem classPath;
        private FileSystemScanner<S> scanner;
        private Snapshot<S> snapshot;
        private ClassLoader classLoader = null;
        private ClassLoader classPathLoader;
        private ReadFileSystem<String[]> classes;
        private boolean failed;

        public Dynamic(Logger logger, ClassLoader baseClassLoader, ReadFileSystem<S> source) {
            super(logger);
            this.baseClassLoader = baseClassLoader;
            this.classPathLoader = new ParentJarClassLoader(baseClassLoader);
            this.scanner = FileSystemScanner.createHashing(source);
            this.snapshot = this.scanner.take();
            this.classPath = null;
            this.failed = false;
        }

        @Override
        public boolean refresh(boolean recompile) throws Exception, CompilationException {
            if (!recompile) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (this.classPath == null) {
                this.classPath = new URLFileSystem().add(this.classPathLoader, ClassLoader.getSystemClassLoader().getParent());
            }
            Snapshot<S> next = this.snapshot.scan();
            if (!this.failed && !next.hasChanges()) {
                this.logger.info("No changes detected");
                return false;
            }
            this.logger.info("Building application");
            this.failed = true;
            final ReadFileSystem<S> sourcePath = this.scanner.getFileSystem();
            final RAMFileSystem classOutput = new RAMFileSystem();
            Compiler compiler = Compiler.builder().sourcePath(sourcePath).sourceOutput(classOutput).classOutput(classOutput).addClassPath(this.classPath).build();
            compiler.addAnnotationProcessor(new MainProcessor());
            compiler.compile();
            sourcePath.copy(new Filter.Default<S>(){

                @Override
                public boolean acceptFile(S file, String name) throws IOException {
                    Iterable<String> names = sourcePath.getNames(file);
                    String[] path = (String[])classOutput.getPath(names);
                    return path == null && !name.endsWith(".java");
                }
            }, classOutput);
            this.classLoader = new LiveClassLoader(new URL[]{classOutput.getURL()}, this.baseClassLoader);
            this.classes = classOutput;
            this.snapshot = next;
            this.failed = false;
            return true;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public ReadFileSystem<String[]> getClasses() {
            return this.classes;
        }
    }
}

