/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import java.util.Map;
import juzu.impl.common.Location;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateException;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.compiler.CompilationPhase;
import juzu.impl.template.spi.juzu.compiler.ExtendedTagHandler;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPhase
extends CompilationPhase {
    private final ProcessContext context;

    public ProcessPhase(ProcessContext context) {
        super(context);
        this.context = context;
    }

    public void process(Template<ASTNode.Template> template) throws TemplateException {
        this.doAttribute(template.getModel());
        this.doProcess(template, template.getModel());
        this.doResolve(template, template.getModel());
        this.doUnattribute(template.getModel());
    }

    public Template resolveTemplate(Path path) throws ProcessingException, TemplateException {
        return this.context.resolveTemplate(path);
    }

    private void doProcess(Template<ASTNode.Template> template, ASTNode<?> node) throws ProcessingException, TemplateException {
        block6: {
            block7: {
                Map<String, String> parameters;
                String methodName;
                block5: {
                    if (!(node instanceof ASTNode.Template)) break block5;
                    for (ASTNode.Block<?> child : node.getChildren()) {
                        this.doProcess(template, child);
                    }
                    break block6;
                }
                if (node instanceof ASTNode.Section) break block6;
                if (!(node instanceof ASTNode.URL)) break block7;
                ASTNode.URL urlNode = (ASTNode.URL)node;
                String typeName = urlNode.getTypeName();
                MethodInvocation mi = this.context.resolveMethodInvocation(typeName, methodName = urlNode.getMethodName(), parameters = urlNode.getArgs());
                if (mi == null) {
                    StringBuilder controller = new StringBuilder();
                    if (typeName != null && typeName.length() > 0) {
                        controller.append(typeName).append('.');
                    }
                    controller.append(methodName).append('(').append(parameters).append(')');
                    Location location = urlNode.getBegin().getPosition();
                    throw TemplateMetaModel.CONTROLLER_NOT_RESOLVED.failure(controller, template.getPath().getCanonical(), location.getLine(), location.getCol());
                }
                urlNode.setInvocation(mi);
                break block6;
            }
            if (!(node instanceof ASTNode.Tag)) break block6;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).process(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doProcess(template, child);
            }
        }
    }

    private void doResolve(Template<ASTNode.Template> template, ASTNode<?> node) throws ProcessingException, TemplateException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doResolve(template, child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).compile(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doResolve(template, child);
            }
        }
    }
}

