/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import juzu.impl.common.Tools;
import juzu.io.Stream;
import juzu.io.Streamable;

class ViewStreamable
implements Streamable {
    private final Streamable wrapped;
    private final boolean decorated;

    ViewStreamable(Streamable wrapped, boolean decorated) {
        this.wrapped = wrapped;
        this.decorated = decorated;
    }

    public void send(final Stream stream) throws IOException {
        Stream our = new Stream(){

            public Stream append(ByteBuffer buffer) throws IOException {
                stream.append(buffer);
                return this;
            }

            public Stream append(CharBuffer buffer) throws IOException {
                stream.append(buffer);
                return this;
            }

            public Stream append(CharSequence csq) throws IOException {
                stream.append(csq);
                return this;
            }

            public Stream append(CharSequence csq, int start, int end) throws IOException {
                stream.append(csq, start, end);
                return this;
            }

            public Stream append(char c) throws IOException {
                stream.append(c);
                return this;
            }

            public Stream append(byte[] data) throws IOException {
                stream.append(data);
                return this;
            }

            public Stream append(byte[] data, int off, int len) throws IOException {
                stream.append(data, off, len);
                return this;
            }

            public void flush() throws IOException {
                stream.flush();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    if (ViewStreamable.this.decorated) {
                        ViewStreamable.this.sendFooter(stream);
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Tools.safeClose(stream);
                    throw throwable;
                }
                Tools.safeClose(stream);
            }
        };
        this.wrapped.send(our);
    }

    private void sendFooter(Stream writer) throws IOException {
        writer.append("</body>\n");
        writer.append("</html>\n");
    }
}

