/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.bridge.spi.portlet.PortletClientContext;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.impl.common.Tools;
import juzu.io.Stream;
import juzu.io.Streams;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletResourceBridge
extends PortletMimeBridge<ResourceRequest, ResourceResponse>
implements ResourceBridge {
    private final PortletClientContext clientContext;

    public PortletResourceBridge(Bridge bridge, ResourceRequest request, ResourceResponse response, PortletConfig config) {
        super(bridge, request, response, config);
        this.clientContext = new PortletClientContext((ClientDataRequest)request);
    }

    @Override
    public Stream createStream(String mimeType, Charset charset) throws IOException {
        if (mimeType != null) {
            ((ResourceResponse)this.resp).setContentType(mimeType);
        }
        if (charset == null) {
            charset = Tools.ISO_8859_1;
        } else {
            ((ResourceResponse)this.resp).setCharacterEncoding(charset.name());
        }
        return Streams.closeable(charset, ((ResourceResponse)this.resp).getPortletOutputStream());
    }

    @Override
    protected Phase getPhase() {
        return Phase.RESOURCE;
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    protected void sendProperties() throws IOException {
        if (this.response instanceof Response.Content) {
            Response.Content resource = (Response.Content)this.response;
            int status = resource.getCode();
            if (status != 200) {
                ((ResourceResponse)this.resp).setProperty("portlet.http-status-code", Integer.toString(status));
            }
            super.setResponse(this.response);
        }
    }
}

