/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import juzu.Method;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.web.WebActionBridge;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRenderBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.bridge.spi.web.WebResourceBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.UriBuilder;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.router.RouteDescriptor;
import juzu.impl.plugin.router.RouterPlugin;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.request.Phase;
import juzu.request.RequestParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements Closeable {
    private static final Phase[] GET_PHASES = new Phase[]{Phase.VIEW, Phase.ACTION, Phase.RESOURCE};
    private static final Phase[] POST_PHASES = new Phase[]{Phase.ACTION, Phase.VIEW, Phase.RESOURCE};
    private static final Phase[] OTHER_PHASES = new Phase[]{Phase.RESOURCE};
    final Bridge bridge;
    final Route root;
    final HashMap<MethodHandle, Route> forwardRoutes;
    final HashMap<Route, Map<Phase, MethodHandle>> backwardRoutes;

    public Handler(Bridge bridge) throws Exception {
        Route root;
        this.bridge = bridge;
        HashMap<MethodHandle, Route> forwardRoutes = new HashMap<MethodHandle, Route>();
        HashMap<Route, HashMap<Phase, MethodHandle>> backwardRoutes = new HashMap<Route, HashMap<Phase, MethodHandle>>();
        RouterPlugin router = bridge.application.resolveBean(RouterPlugin.class);
        if (router != null) {
            RouteDescriptor route = router.getDescriptor();
            if (route != null) {
                Map<RouteDescriptor, Route> ret = route.create();
                root = ret.values().iterator().next();
                for (Map.Entry<RouteDescriptor, Route> entry : ret.entrySet()) {
                    for (Map.Entry<String, String> entry2 : entry.getKey().getTargets().entrySet()) {
                        MethodHandle handle = MethodHandle.parse(entry2.getValue());
                        Phase phase = Phase.valueOf(entry2.getKey());
                        forwardRoutes.put(handle, entry.getValue());
                        HashMap<Phase, MethodHandle> map = (HashMap<Phase, MethodHandle>)backwardRoutes.get(entry.getValue());
                        if (map == null) {
                            map = new HashMap<Phase, MethodHandle>();
                            backwardRoutes.put(entry.getValue(), map);
                        }
                        map.put(phase, handle);
                    }
                }
            } else {
                root = new Router();
            }
        } else {
            root = new Router();
        }
        this.forwardRoutes = forwardRoutes;
        this.backwardRoutes = backwardRoutes;
        this.root = root;
    }

    public Map<Phase, MethodHandle> getMethods(Route route) {
        return this.backwardRoutes.get(route);
    }

    public Route getRoute(MethodHandle method) {
        return this.forwardRoutes.get(method);
    }

    public Route getRoot() {
        return this.root;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public void handle(WebBridge bridge) throws Throwable {
        Map<Phase, MethodHandle> m;
        String requestPath = bridge.getRequestPath();
        RouteMatch requestMatch = null;
        if (requestPath.startsWith(bridge.getPath())) {
            requestMatch = this.root.route(requestPath.substring(bridge.getPath().length()), Collections.<String, String[]>emptyMap());
        }
        juzu.impl.request.Method requestMethod = null;
        Map<String, RequestParameter> requestParameters = Collections.emptyMap();
        if (requestMatch != null && (m = this.getMethods(requestMatch.getRoute())) != null) {
            Phase[] phases = Method.GET == bridge.getHttpContext().getMethod() ? GET_PHASES : (Method.POST == bridge.getHttpContext().getMethod() ? POST_PHASES : OTHER_PHASES);
            for (Phase phase : phases) {
                MethodHandle handle = m.get(phase);
                if (handle == null) continue;
                requestMethod = this.bridge.application.resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(handle);
                if (requestMatch.getMatched().size() <= 0 && bridge.getParameters().size() <= 0) break;
                requestParameters = new HashMap<String, RequestParameter>();
                for (RequestParameter requestParameter : bridge.getParameters().values()) {
                    requestParameters.put(requestParameter.getName(), requestParameter);
                }
                for (Map.Entry entry : requestMatch.getMatched().entrySet()) {
                    RequestParameter requestParameter = RequestParameter.create(((PathParam)entry.getKey()).getName(), (String)entry.getValue());
                    requestParameters.put(requestParameter.getName(), requestParameter);
                }
                break;
            }
        }
        if (requestMethod == null) {
            requestMethod = this.bridge.application.resolveBean(ControllerPlugin.class).getResolver().resolve(Phase.VIEW, Collections.<String>emptySet());
        }
        if (requestMethod == null) {
            bridge.setStatus(404);
        } else {
            WebRequestBridge requestBridge;
            Route requestRoute;
            if (requestMatch == null && (requestRoute = this.getRoute(requestMethod.getHandle())) != null && (requestMatch = requestRoute.matches(Collections.<String, String>emptyMap())) != null) {
                StringBuilder sb = new StringBuilder();
                requestMatch.render(new UriBuilder(sb));
                if (!sb.toString().equals(requestPath)) {
                    StringBuilder redirect = new StringBuilder();
                    bridge.renderRequestURL(redirect);
                    redirect.append((CharSequence)sb);
                    bridge.sendRedirect(redirect.toString());
                    return;
                }
            }
            if (requestMethod.getPhase() == Phase.ACTION) {
                requestBridge = new WebActionBridge(this.bridge, this, bridge, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.VIEW) {
                requestBridge = new WebRenderBridge(this.bridge, this, bridge, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.RESOURCE) {
                requestBridge = new WebResourceBridge(this.bridge, this, bridge, requestMethod, requestParameters);
            } else {
                throw new Exception("Cannot decode phase");
            }
            requestBridge.invoke();
            if (!requestBridge.send()) {
                throw new UnsupportedOperationException("Not yet handled by " + requestBridge.getClass().getSimpleName() + ": " + requestBridge.response);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

