/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;
import juzu.io.CharStream;
import juzu.io.Stream;

public class AppendableStream
extends CharStream {
    private final Appendable out;
    private final Flushable flushable;
    private final Closeable closeable;

    public AppendableStream(Charset charset, Appendable out) {
        super(charset);
        this.out = out;
        this.flushable = null;
        this.closeable = null;
    }

    public AppendableStream(Charset charset, Appendable out, Flushable flushable, Closeable closeable) {
        super(charset);
        this.out = out;
        this.flushable = flushable;
        this.closeable = closeable;
    }

    public Stream append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    public Stream append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    public Stream append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    public void flush() throws IOException {
        if (this.flushable != null) {
            this.flushable.flush();
        }
    }
}

