/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatting {
    public static void renderStyleSheet(Writer writer) throws IOException {
        URL cssURL = Formatting.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        writer.append("<script type='text/javascript'>\n");
        writer.append("var styleElement = document.createElement('style');\n");
        writer.append("var css = '");
        writer.append(css);
        writer.append("';\n");
        writer.append("styleElement.type = 'text/css';\n");
        writer.append("if (styleElement.styleSheet) {;\n");
        writer.append("styleElement.styleSheet.cssText = css;\n");
        writer.append("} else {\n");
        writer.append("styleElement.appendChild(document.createTextNode(css));\n");
        writer.append("}\n");
        writer.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        writer.append("</script>\n");
    }

    public static void renderThrowable(Class<?> stop, Writer writer, Throwable t) throws IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (stop != null && element.getClassName().equals(stop.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter(writer){

            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></div>");
                }
                super.append("<p>");
                super.append(String.valueOf(x));
                super.append("</p>");
                open.set(false);
            }

            public void println(String x) {
                if (!open.get()) {
                    super.append("<div class=\"code\"><ul>");
                    open.set(true);
                }
                super.append("<li><p>");
                super.append(x);
                super.append("</p></li>");
            }

            public void println() {
            }
        };
        writer.append("<section>");
        t.printStackTrace(formatter);
        if (open.get()) {
            writer.append("</ul></div>");
        }
        writer.append("</section>");
    }

    public static void renderErrors(Writer writer, Iterable<CompilationError> errors) throws IOException {
        Formatting.renderStyleSheet(writer);
        for (CompilationError error : errors) {
            writer.append("<section>");
            writer.append("<p>").append(error.getMessage()).append("</p>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                writer.append("<div class=\"code\"><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            writer.append("<li><p class=\"error\">").append(s).append("</p></li>");
                        } else {
                            writer.append("<li><p>").append(s).append("</p></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                writer.append("</ol></div>");
            }
            writer.append("</section>");
        }
    }
}

