/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject;

import juzu.Scope;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;

public class ScopeController {
    final ThreadLocal<ScopingContext> currentContext = new ThreadLocal();

    public void begin(ScopingContext context) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.currentContext.get() != null) {
            throw new IllegalStateException("Already started");
        }
        this.currentContext.set(context);
    }

    public void end() {
        this.currentContext.set(null);
    }

    public Scoped get(Scope scope, Object key) throws IllegalStateException {
        ScopingContext ctx = this.currentContext.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not active");
        }
        if (!ctx.isActive(scope)) {
            throw new IllegalStateException("Context not active");
        }
        return ctx.getContextualValue(scope, key);
    }

    public void put(Scope scope, Object key, Scoped scoped) throws IllegalStateException {
        ScopingContext ctx = this.currentContext.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not active");
        }
        if (!ctx.isActive(scope)) {
            throw new IllegalStateException("Context not active");
        }
        ctx.setContextualValue(scope, key, scoped);
    }

    public boolean isActive(Scope scope) {
        ScopingContext ctx = this.currentContext.get();
        return ctx != null && ctx.isActive(scope);
    }
}

