/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.war;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import juzu.impl.common.Resource;
import juzu.impl.common.Spliterator;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WarFileSystem
extends ReadFileSystem<String> {
    private final String mountPoint;

    public WarFileSystem(String mountPoint) throws NullPointerException {
        if (mountPoint == null) {
            throw new NullPointerException("No null mount point accepted");
        }
        if (!mountPoint.startsWith("/") || !mountPoint.endsWith("/")) {
            throw new IllegalArgumentException("Invalid mount point " + mountPoint);
        }
        this.mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public boolean equals(String left, String right) {
        return left.equals(right);
    }

    @Override
    public String getRoot() {
        return "/";
    }

    @Override
    public String getName(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public Iterable<String> getNames(String path) {
        int to = path.length();
        if (path.endsWith("/")) {
            --to;
        }
        return Spliterator.split(path, 0, to, '/');
    }

    @Override
    public Iterator<String> getChildren(String dir) throws IOException {
        return this.getResourcePaths(dir).iterator();
    }

    @Override
    public String getChild(String dir, String name) throws IOException {
        Iterator<String> i = this.getChildren(dir);
        while (i.hasNext()) {
            String child = i.next();
            String childName = this.getName(child);
            if (!childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public PathType typeOf(String path) throws IOException {
        if (path.endsWith("/")) {
            return PathType.DIR;
        }
        URL url = this.getResourceURL(path);
        if (url != null) {
            return PathType.FILE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamped<Resource> getResource(String file) throws IOException {
        URL url = this.getResourceURL(file);
        if (url != null) {
            URLConnection conn = url.openConnection();
            long lastModified = conn.getLastModified();
            InputStream in = conn.getInputStream();
            try {
                ByteArrayOutputStream resource = new ByteArrayOutputStream();
                byte[] buffer = new byte[256];
                int l = in.read(buffer);
                while (l != -1) {
                    resource.write(buffer, 0, l);
                    l = in.read(buffer);
                }
                Timestamped<Resource> timestamped = new Timestamped<Resource>(lastModified, new Resource(resource.toByteArray(), Charset.defaultCharset()));
                return timestamped;
            }
            finally {
                Tools.safeClose(in);
            }
        }
        throw new UnsupportedOperationException("handle me gracefully");
    }

    @Override
    public long getLastModified(String path) throws IOException {
        URL url = this.getResourceURL(path);
        URLConnection conn = url.openConnection();
        return conn.getLastModified();
    }

    @Override
    public URL getURL(String path) throws IOException {
        return this.getResourceURL(path);
    }

    protected abstract Set<String> doGetResourcePaths(String var1) throws IOException;

    protected abstract URL doGetResource(String var1) throws IOException;

    protected abstract String doGetRealPath(String var1);

    private Collection<String> getResourcePaths(String path) throws IOException {
        Set<String> resourcePaths = this.doGetResourcePaths(this.mountPoint + path);
        if (resourcePaths != null) {
            ArrayList<String> tmp = new ArrayList<String>(resourcePaths.size());
            for (String resourcePath : resourcePaths) {
                tmp.add(resourcePath.substring(this.mountPoint.length()));
            }
            return tmp;
        }
        return Collections.emptyList();
    }

    @Override
    public File getFile(String path) {
        String realPath = this.doGetRealPath(this.mountPoint + path);
        return realPath == null ? null : new File(realPath);
    }

    private URL getResourceURL(String path) throws IOException {
        return this.doGetResource(this.mountPoint + path);
    }

    public static WarFileSystem create(ServletContext context) {
        return WarFileSystem.create(context, "/");
    }

    public static WarFileSystem create(final ServletContext servletContext, String mountPoint) {
        return new WarFileSystem(mountPoint){

            @Override
            public String getDescription() {
                return "servlet[" + servletContext.getRealPath("/") + "]";
            }

            @Override
            protected Set<String> doGetResourcePaths(String path) throws IOException {
                return servletContext.getResourcePaths(path);
            }

            @Override
            protected URL doGetResource(String path) throws IOException {
                String realPath = servletContext.getRealPath(path);
                if (realPath != null) {
                    return new File(realPath).toURI().toURL();
                }
                return servletContext.getResource(path);
            }

            @Override
            protected String doGetRealPath(String path) {
                return servletContext.getRealPath(path);
            }
        };
    }

    public static WarFileSystem create(PortletContext portletContext) {
        return WarFileSystem.create(portletContext, "/");
    }

    public static WarFileSystem create(final PortletContext portletContext, String mountPoint) {
        return new WarFileSystem(mountPoint){

            @Override
            public String getDescription() {
                return "servlet[" + portletContext.getRealPath("/") + "]";
            }

            @Override
            protected Set<String> doGetResourcePaths(String path) throws IOException {
                return portletContext.getResourcePaths(path);
            }

            @Override
            protected URL doGetResource(String path) throws IOException {
                String realPath = portletContext.getRealPath(path);
                if (realPath != null) {
                    return new File(realPath).toURI().toURL();
                }
                return portletContext.getResource(path);
            }

            @Override
            protected String doGetRealPath(String path) {
                return portletContext.getRealPath(path);
            }
        };
    }
}

