/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;

public abstract class TemplateStub {
    private static final int CONSTRUCTED = 0;
    private static final int INITIALIZING = 1;
    private static final int INITIALIZED = 2;
    protected final ClassLoader loader;
    protected final String id;
    private final AtomicInteger status;

    protected TemplateStub(ClassLoader loader, String id) {
        if (loader == null) {
            throw new NullPointerException("No null loader accepted");
        }
        if (id == null) {
            id = this.getClass().getName().substring(0, this.getClass().getName().length() - 1);
        }
        this.id = id;
        this.status = new AtomicInteger(0);
        this.loader = loader;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws NullPointerException {
        block7: while (true) {
            switch (this.status.get()) {
                case 0: {
                    if (!this.status.compareAndSet(0, 1)) continue block7;
                    int next = 0;
                    try {
                        this.doInit(this.loader);
                        next = 2;
                        continue block7;
                    }
                    finally {
                        this.status.set(next);
                        continue block7;
                    }
                }
                case 1: {
                    continue block7;
                }
            }
            break;
        }
    }

    public final void render(TemplateRenderContext renderContext) throws TemplateExecutionException, IOException, IllegalStateException {
        block4: while (true) {
            switch (this.status.get()) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    this.doRender(renderContext);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Template stub is not initialized " + this.status.get());
    }

    protected abstract void doInit(ClassLoader var1);

    protected abstract void doRender(TemplateRenderContext var1) throws TemplateExecutionException, IOException;
}

