/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.plugin.amd.NormalizeJSReader;
import juzu.impl.plugin.asset.Asset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleAsset
extends Asset {
    private final String adapter;
    private final LinkedHashMap<String, String> a;

    public ModuleAsset(Map<String, Serializable> asset, String adapter, List<String> aliases) {
        super("module", asset);
        LinkedHashMap a;
        if (this.depends != null && aliases != null) {
            a = new LinkedHashMap();
            int size = Math.min(this.depends.size(), aliases.size());
            for (int i = 0; i < size; ++i) {
                a.put(this.depends.get(i), aliases.get(i));
            }
        } else {
            a = null;
        }
        this.depends.add("juzu.amd");
        this.adapter = adapter;
        this.a = a;
    }

    @Override
    public InputStream filter(InputStream stream) throws IOException {
        if (this.a != null || this.adapter != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("\ndefine('").append(this.id).append("', [");
            this.joinDependencies(sb);
            sb.append("], function(");
            this.joinParams(sb);
            sb.append(") {");
            sb.append("var define = function() {");
            sb.append("return arguments[2].apply(this, [");
            this.joinParams(sb);
            sb.append("]);");
            sb.append("};");
            sb.append("\nreturn ");
            int idx = -1;
            if (this.adapter != null && !this.adapter.isEmpty()) {
                idx = this.adapter.indexOf("@{include}");
            }
            if (idx != -1) {
                sb.append(this.adapter.substring(0, idx)).append("\n");
            }
            NormalizeJSReader reader = new NormalizeJSReader(new InputStreamReader(stream));
            char[] buffer = new char[512];
            while (true) {
                int i;
                if ((i = reader.read(buffer)) == 0) {
                    continue;
                }
                if (i == -1) break;
                sb.append(buffer, 0, i);
            }
            if (idx != -1) {
                sb.append(this.adapter.substring(idx + "@{include}".length(), this.adapter.length()));
            }
            sb.append("\n});");
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        return stream;
    }

    private void joinDependencies(StringBuilder sb) {
        if (this.a != null) {
            Iterator<String> i = this.a.keySet().iterator();
            while (i.hasNext()) {
                sb.append("'").append(i.next()).append("'");
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
    }

    private void joinParams(StringBuilder sb) {
        if (this.a != null) {
            Iterator<String> i = this.a.values().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
    }
}

