/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Asset
implements Serializable {
    public final String id;
    public final String type;
    public final String value;
    public final List<String> depends;
    public final AssetLocation location;

    public Asset(String type, Map<String, Serializable> asset) {
        String id = (String)((Object)asset.get("id"));
        String value = (String)((Object)asset.get("value"));
        List depends = (List)((Object)asset.get("depends"));
        AssetLocation location = AssetLocation.safeValueOf((String)((Object)asset.get("location")));
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (location == null) {
            throw new IllegalArgumentException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.value = value;
        this.depends = depends != null ? depends : new ArrayList();
        this.location = location;
    }

    public Asset(String id, String type, String value, List<String> depends, AssetLocation location) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        if (location == null) {
            throw new NullPointerException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.value = value;
        this.depends = depends;
        this.location = location;
    }

    public JSON getJSON() {
        JSON json = new JSON().set("value", this.value).set("type", this.type);
        if (this.id != null) {
            json.set("id", this.id);
        }
        if (this.depends != null) {
            json.set("depends", this.depends);
        }
        if (this.location != null) {
            json.set("location", this.location.toString());
        }
        return json;
    }

    public InputStream filter(InputStream stream) throws IOException {
        return stream;
    }
}

