/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import juzu.impl.common.CycleDetectionException;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.template.metamodel.AbstractEmitter;
import juzu.impl.plugin.template.metamodel.MetaModelProcessContext;
import juzu.impl.plugin.template.metamodel.TagContainerMetaModel;
import juzu.impl.plugin.template.metamodel.Template;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerMetaModel
extends MetaModelObject
implements Iterable<TemplateMetaModel> {
    private static final Logger log = BaseProcessor.getLogger(AbstractEmitter.class);
    ApplicationMetaModel application;
    Name qn;
    AbstractEmitter emitter;
    TemplateMetaModelPlugin plugin;
    final Name name;
    final HashMap<Path.Absolute, TemplateMetaModel> templates;

    public AbstractContainerMetaModel(Name name) {
        this.name = name;
        this.templates = new HashMap();
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.map("values", this.getChildren(TemplateMetaModel.class));
        json.set("qn", this.qn);
        return json;
    }

    final TagHandler resolveTagHandler(String name) {
        TagContainerMetaModel tags = this.application.getChild(TagContainerMetaModel.KEY);
        TagHandler handler = tags.resolveApplicationTagHandler(name);
        if (handler == null) {
            handler = this.plugin.tags.get(name);
        }
        return handler;
    }

    final void postActivate(TemplateMetaModelPlugin plugin) {
        this.plugin = plugin;
        this.evictTemplates();
    }

    void prePassivate() {
        this.emitter.prePassivate();
        this.plugin = null;
    }

    void postProcessEvents() {
        this.resolve();
        this.emit();
    }

    public Path.Absolute resolvePath(Path path) {
        return this.qn.resolve(path);
    }

    public ApplicationMetaModel getApplication() {
        return this.application;
    }

    public Name getQN() {
        return this.qn;
    }

    public TemplateMetaModel get(Path.Absolute path) {
        return this.templates.get(path);
    }

    @Override
    public Iterator<TemplateMetaModel> iterator() {
        return this.getChildren(TemplateMetaModel.class).iterator();
    }

    private void evictTemplates() {
        log.info("Synchronizing existing templates");
        for (TemplateMetaModel template : this.templates.values()) {
            if (template.templateModel == null) continue;
            FileObject resource = this.application.resolveResource(template.getPath());
            if (resource == null) {
                template.templateModel = null;
                log.info("Detected template removal " + template.getPath());
                continue;
            }
            if (resource.getLastModified() > template.templateModel.getLastModified()) {
                template.templateModel = null;
                log.info("Detected stale template " + template.getPath());
                continue;
            }
            log.info("Template " + template.getPath() + " is valid");
        }
    }

    void resolve() {
        for (final TemplateMetaModel template : new ArrayList<TemplateMetaModel>(this.templates.values())) {
            if (template.templateModel != null) continue;
            Element[] elements = this.getElements(template);
            this.application.getProcessingContext().executeWithin(elements[0], new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MetaModelProcessContext processContext = new MetaModelProcessContext(AbstractContainerMetaModel.this, template);
                    processContext.resolve(template);
                    return null;
                }
            });
        }
    }

    void emit() {
        for (TemplateMetaModel template : this.templates.values()) {
            Element[] elements = this.getElements(template);
            this.emitter.emit(template, elements);
        }
    }

    protected abstract Element[] getElements(TemplateMetaModel var1);

    public Template add(Path.Relative path, List<TemplateRefMetaModel> ref) {
        return this.add(this.resolvePath(path), ref);
    }

    public Template add(Path.Absolute path, Iterable<TemplateRefMetaModel> refs) {
        if (this.qn.isPrefix(path.getName())) {
            TemplateMetaModel template = this.templates.get(path);
            if (template == null) {
                template = new TemplateMetaModel(this, path);
            }
            for (TemplateRefMetaModel ref : refs) {
                try {
                    ref.add(template);
                }
                catch (CycleDetectionException e) {
                    StringBuilder path1 = new StringBuilder();
                    for (Object node : e.getPath()) {
                        if (path1.length() > 0) {
                            path1.append("->");
                        }
                        if (node instanceof TemplateMetaModel) {
                            TemplateMetaModel templateNode = (TemplateMetaModel)node;
                            path1.append(templateNode.getPath().getValue());
                            continue;
                        }
                        path1.append(node);
                    }
                    throw TemplateMetaModel.TEMPLATE_CYCLE.failure(path, path1);
                }
            }
            return template;
        }
        return new Template(){};
    }

    protected abstract AbstractEmitter createEmitter();

    protected abstract TemplateProvider<?> resolveTemplateProvider(String var1);

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ApplicationMetaModel) {
            this.application = (ApplicationMetaModel)parent;
            this.qn = this.application.getName().append(this.name);
            this.emitter = this.createEmitter();
        }
    }
}

