/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hudson.AbstractMemoryMonitorImpl;
import org.jvnet.hudson.MemoryUsage;

final class Top
extends AbstractMemoryMonitorImpl {
    private boolean plainTopFailed;
    private static final Pattern[][] PATTERNS = new Pattern[][]{{Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) phys mem"), Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) total"), Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) real")}, {Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) free"), Pattern.compile("^physmem:.* ([0-9.]+[kmgb]) free")}, {Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) swap,"), Pattern.compile("^swap:.* ([0-9.]+[kmgb]) total")}, {Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) free swap"), Pattern.compile("^swap:.* ([0-9.]+[kmb]) free"), Pattern.compile("^mem(?:ory)?:.* ([0-9.]+[kmgb]) swap free")}, {Pattern.compile("^physmem:.* ([0-9.]+[kmgb]) used")}, {Pattern.compile("^mem(?:ory):.* ([0-9.]+[kmgb]) swap in use")}};
    private static final Pattern ESCAPE_SEQUENCE = Pattern.compile("\u001b\\[[0-9;]+m");

    Top() {
    }

    public MemoryUsage monitor() throws IOException {
        MemoryUsage r;
        if (!this.plainTopFailed) {
            r = this.monitor("top");
            if (r != null) {
                return r;
            }
            this.plainTopFailed = true;
        }
        if ((r = this.monitor("top", "-b")) != null) {
            return r;
        }
        throw new IOException("'top' unavailable");
    }

    private MemoryUsage monitor(String ... args) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        proc.getOutputStream().close();
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((line = in.readLine()) != null && lines.size() < 8) {
            lines.add(ESCAPE_SEQUENCE.matcher(line.toLowerCase()).replaceAll(""));
        }
        proc.destroy();
        in.close();
        long[] values = new long[6];
        Arrays.fill(values, -1L);
        block3: for (int i = 0; i < PATTERNS.length; ++i) {
            for (Pattern p : PATTERNS[i]) {
                for (String line2 : lines) {
                    try {
                        Matcher m = p.matcher(line2);
                        if (!m.find()) continue;
                        values[i] = this.parse(m.group(1));
                        continue block3;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Failed to parse " + line2);
                    }
                }
            }
        }
        if (values[0] == -1L && values[1] != -1L && values[4] != -1L) {
            values[0] = values[1] + values[4];
        }
        if (values[2] == -1L && values[3] != -1L && values[5] != -1L) {
            values[2] = values[3] + values[5];
        }
        if (MemoryUsage.hasData(values)) {
            return new MemoryUsage(values);
        }
        return null;
    }
}

