/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.remcom;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbNamedPipe;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JISession;
import org.jvnet.hudson.remcom.Payload;
import org.jvnet.hudson.remcom.RemComRequest;
import org.jvnet.hudson.remcom.RemComResponse;
import org.jvnet.hudson.wmi.SWbemServices;
import org.jvnet.hudson.wmi.WMI;
import org.jvnet.hudson.wmi.Win32Service;

public class WindowsRemoteProcessLauncher {
    private final String hostName;
    private final IJIAuthInfo credential;
    private int timeout = 5000;
    private final Random random = new Random();
    private static final Logger LOGGER = Logger.getLogger(WindowsRemoteProcessLauncher.class.getName());
    private static final InputStream NULL = new ByteArrayInputStream(new byte[0]);

    public WindowsRemoteProcessLauncher(String hostName, IJIAuthInfo credential) {
        this.hostName = hostName;
        this.credential = credential;
    }

    public void setConnectionTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    public String getHostName() {
        return this.hostName;
    }

    private NtlmPasswordAuthentication createSmbAuth() throws IOException {
        return new NtlmPasswordAuthentication(this.credential.getDomain(), this.credential.getUserName(), this.credential.getPassword());
    }

    public Process launch(String command, String workingDirectory) throws IOException, JIException, InterruptedException {
        JISession session = JISession.createSession((IJIAuthInfo)this.credential);
        session.setGlobalSocketTimeout(60000);
        SWbemServices services = WMI.connect((JISession)session, (String)this.hostName);
        NtlmPasswordAuthentication smbAuth = this.createSmbAuth();
        Win32Service rsvc = services.getService("RemComSVC");
        if (rsvc == null) {
            LOGGER.fine("Creating a service");
            SmbFile remComSvcExe = new SmbFile("smb://" + this.hostName + "/ADMIN$/RemComSvc.exe", smbAuth);
            this.copyAndClose(WindowsRemoteProcessLauncher.class.getResourceAsStream("RemComSvc.exe"), remComSvcExe.getOutputStream());
            Win32Service svc = (Win32Service)services.Get("Win32_Service").cast(Win32Service.class);
            int r = svc.Create("RemComSvc", "Remote Communication Service", "%SystemRoot%\\RemComSvc.exe", 16, 1, "Manual", false);
            if (r != 0) {
                throw new IOException("Failed to register a service");
            }
            Thread.sleep(1000L);
            rsvc = services.getService("RemComSVC");
        }
        if (!rsvc.State().equals("Running")) {
            LOGGER.fine("Starting a service");
            rsvc = services.getService("RemComSVC");
            rsvc.start();
        }
        String path = "smb://" + this.hostName + "/IPC$/pipe/RemCom_communicaton";
        LOGGER.fine("Trying to connect to " + path);
        SmbNamedPipe comm = new SmbNamedPipe(path, 3, smbAuth);
        final DataInputStream in = new DataInputStream(new BufferedInputStream(this.openForRead(comm)));
        final OutputStream out = this.openForWrite(comm);
        LOGGER.fine("Sending launch request");
        RemComRequest req = new RemComRequest();
        req.command = command;
        req.workingDir = workingDirectory;
        req.machine = Integer.toHexString(this.hashCode());
        req.processId = this.random.nextInt(65536);
        out.write(req.pack());
        final RemComResponse[] result = new RemComResponse[1];
        final OutputStream stdout = new OutputStream(){
            boolean closed;

            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                if (this.closed) {
                    throw new IOException("stream is already closed");
                }
                if (len == 0) {
                    return;
                }
                Payload.write(b, off, len, out);
            }

            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    out.write(new byte[4]);
                }
            }
        };
        final InputStream stdin = new InputStream(){
            private byte[] buf;
            private int remaining;
            private boolean eof;

            public int read() throws IOException {
                if (!this.fetch()) {
                    return -1;
                }
                return this.buf[this.buf.length - this.remaining--] & 0xFF;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fetch() throws IOException {
                if (this.eof) {
                    return false;
                }
                if (this.remaining == 0) {
                    Object o = Payload.read(in);
                    if (o instanceof RemComResponse) {
                        result[0] = (RemComResponse)o;
                        RemComResponse[] remComResponseArray = result;
                        synchronized (result) {
                            result.notifyAll();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            this.eof = true;
                            return false;
                        }
                    }
                    this.buf = (byte[])o;
                    this.remaining = this.buf.length;
                }
                return true;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (this.eof || !this.fetch()) {
                    return -1;
                }
                int sz = Math.min(len, this.remaining);
                System.arraycopy(this.buf, this.buf.length - this.remaining, b, off, sz);
                this.remaining -= sz;
                return sz;
            }
        };
        final JISession s = session;
        return new Process(){
            private Integer exitCode;

            public OutputStream getOutputStream() {
                return stdout;
            }

            public InputStream getInputStream() {
                return stdin;
            }

            public InputStream getErrorStream() {
                return NULL;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized int waitFor() throws InterruptedException {
                RemComResponse[] remComResponseArray = result;
                synchronized (result) {
                    while (result[0] == null) {
                        result.wait();
                    }
                    if (result[0].errorCode != 0) {
                        this.exitCode = 10000000 + result[0].errorCode;
                    }
                    this.exitCode = result[0].returnCode;
                    this.destroy();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.exitCode;
                }
            }

            public synchronized int exitValue() {
                if (this.exitCode == null) {
                    throw new IllegalThreadStateException();
                }
                return this.exitCode;
            }

            public synchronized void destroy() {
                if (this.exitCode == null) {
                    this.exitCode = -1;
                }
                try {
                    JISession.destroySession((JISession)s);
                }
                catch (JIException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private OutputStream openForWrite(SmbNamedPipe pipe) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return pipe.getNamedPipeOutputStream();
            }
            catch (SmbException e) {
                if (e.getNtStatus() != -1073741650) {
                    throw e;
                }
                if (start + (long)this.timeout < System.currentTimeMillis()) {
                    throw e;
                }
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }

    private InputStream openForRead(SmbNamedPipe pipe) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                SmbFileInputStream in = (SmbFileInputStream)pipe.getNamedPipeInputStream();
                in.setTimeout(86400000L);
                return in;
            }
            catch (SmbException e) {
                if (e.getNtStatus() != -1073741650) {
                    throw e;
                }
                if (start + (long)this.timeout < System.currentTimeMillis()) {
                    throw e;
                }
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }

    private void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buf = new byte[4096];
            while (true) {
                int len;
                if ((len = in.read(buf)) < 0) {
                    return;
                }
                out.write(buf, 0, len);
            }
        }
        finally {
            this.close(in);
            this.close(out);
        }
    }

    private void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to close a stream", e);
        }
    }
}

