/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven;

import java.text.MessageFormat;
import org.apache.maven.model.Dependency;
import org.jvnet.jaxb.maven.util.StringUtils;

public class DependencyResource
extends Dependency {
    private static final long serialVersionUID = -7680130645800522100L;
    private String resource;
    private String systemId;

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public DependencyResource() {
        this.setScope("runtime");
    }

    public String toString() {
        return "Dependency {groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", resource=" + this.getResource() + "}";
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        if (this.systemId != null) {
            return this.systemId;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("maven").append(':');
        sb.append(this.getGroupId()).append(':');
        sb.append(this.getArtifactId()).append(':');
        sb.append(this.getType() == null ? "" : this.getType()).append(':');
        sb.append(this.getClassifier() == null ? "" : this.getClassifier()).append(':');
        sb.append(this.getVersion() == null ? "" : this.getVersion());
        sb.append("!/");
        sb.append(this.getResource());
        return sb.toString();
    }

    public static DependencyResource valueOf(String value) throws IllegalArgumentException {
        String resource;
        String dependencyPart;
        String resourceDelimiter = "!/";
        int resourceDelimiterPosition = value.indexOf("!/");
        if (resourceDelimiterPosition == -1) {
            dependencyPart = value;
            resource = "";
        } else {
            dependencyPart = value.substring(0, resourceDelimiterPosition);
            resource = value.substring(resourceDelimiterPosition + "!/".length());
        }
        String[] dependencyParts = StringUtils.split(dependencyPart, ':', true);
        if (dependencyParts.length < 2) {
            throw new IllegalArgumentException(MessageFormat.format("Error parsing dependency descriptor [{0}], both groupId and artifactId must be specified.", dependencyPart));
        }
        if (dependencyParts.length > 5) {
            throw new IllegalArgumentException(MessageFormat.format("Error parsing dependency descriptor [{0}], it contains too many parts.", dependencyPart));
        }
        String groupId = dependencyParts[0];
        String artifactId = dependencyParts[1];
        String type = dependencyParts.length > 2 ? (dependencyParts[2] == null || dependencyParts[2].length() == 0 ? null : dependencyParts[2]) : null;
        String classifier = dependencyParts.length > 3 ? (dependencyParts[3] == null || dependencyParts[3].length() == 0 ? null : dependencyParts[3]) : null;
        String version = dependencyParts.length > 4 ? (dependencyParts[4] == null || dependencyParts[4].length() == 0 ? null : dependencyParts[4]) : null;
        DependencyResource dependencyResource = new DependencyResource();
        dependencyResource.setGroupId(groupId);
        dependencyResource.setArtifactId(artifactId);
        if (version != null) {
            dependencyResource.setVersion(version);
        }
        if (type != null) {
            dependencyResource.setType(type);
        }
        if (classifier != null) {
            dependencyResource.setClassifier(classifier);
        }
        if (resource != null) {
            dependencyResource.setResource(resource);
        }
        dependencyResource.setSystemId(value);
        return dependencyResource;
    }
}

