/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.repository.RepositorySystem;
import org.jvnet.jaxb.maven.util.CollectionUtils;

public class ArtifactUtils {
    public static final CollectionUtils.Function<Artifact, File> GET_FILE = new CollectionUtils.Function<Artifact, File>(){

        @Override
        public File eval(Artifact argument) {
            return argument.getFile();
        }
    };

    private ArtifactUtils() {
    }

    public static Collection<Artifact> resolveTransitively(ArtifactFactory artifactFactory, RepositorySystem artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Dependency[] dependencies, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        return ArtifactUtils.resolveTransitively(artifactFactory, artifactResolver, localRepository, artifactMetadataSource, dependencies, project, (Log)new SystemStreamLog(), null);
    }

    public static Collection<Artifact> resolveTransitively(ArtifactFactory artifactFactory, RepositorySystem artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Dependency[] dependencies, MavenProject project, Log log, String[] artifactExcludes) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (dependencies == null || dependencies.length == 0) {
            return Collections.emptyList();
        }
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)artifactFactory, Arrays.asList(dependencies), (String)"runtime", null, (MavenProject)project);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveTransitively(true);
        request.setResolveRoot(false);
        request.setArtifact(project.getArtifact());
        request.setArtifactDependencies(artifacts);
        if (artifactExcludes != null && artifactExcludes.length > 0) {
            request.setCollectionFilter((ArtifactFilter)new ExclusionSetFilter(artifactExcludes));
        }
        request.setRemoteRepositories(project.getRemoteArtifactRepositories());
        request.setLocalRepository(localRepository);
        ArtifactResolutionResult artifactResolutionResult = artifactResolver.resolve(request);
        if (!artifactResolutionResult.isSuccess()) {
            if (artifactResolutionResult.hasMissingArtifacts()) {
                log.error((CharSequence)("artifactResolutionResult has missing artifacts : " + artifactResolutionResult.getMissingArtifacts()));
                throw new RuntimeException("Artifacts - missing artifacts");
            }
            if (artifactResolutionResult.hasExceptions()) {
                log.error((CharSequence)("artifactResolutionResult has exceptions : " + artifactResolutionResult.getExceptions()));
                throw new RuntimeException("Artifacts - exceptions", (Throwable)artifactResolutionResult.getExceptions().get(0));
            }
            log.error((CharSequence)"artifactResolutionResult status is not success");
            throw new RuntimeException("Artifacts - not in success");
        }
        return artifactResolutionResult.getArtifacts();
    }

    public static Collection<Artifact> resolve(ArtifactFactory artifactFactory, RepositorySystem artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Dependency[] dependencies, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (dependencies == null || dependencies.length == 0) {
            return Collections.emptyList();
        }
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)artifactFactory, Arrays.asList(dependencies), (String)"runtime", null, (MavenProject)project);
        for (Artifact artifact : artifacts) {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setArtifact(artifact);
            request.setRemoteRepositories(project.getRemoteArtifactRepositories());
            request.setLocalRepository(localRepository);
            artifactResolver.resolve(request);
        }
        Set resolvedArtifacts = artifacts;
        return resolvedArtifacts;
    }

    public static final Collection<File> getFiles(Collection<Artifact> artifacts) {
        return CollectionUtils.apply(artifacts, GET_FILE);
    }

    public static void mergeDependencyWithDefaults(Dependency dep, Dependency def) {
        List exclusions;
        if (dep.getScope() == null && def.getScope() != null) {
            dep.setScope(def.getScope());
            dep.setSystemPath(def.getSystemPath());
        }
        if (dep.getVersion() == null && def.getVersion() != null) {
            dep.setVersion(def.getVersion());
        }
        if (dep.getClassifier() == null && def.getClassifier() != null) {
            dep.setClassifier(def.getClassifier());
        }
        if (dep.getType() == null && def.getType() != null) {
            dep.setType(def.getType());
        }
        if ((exclusions = dep.getExclusions()) == null || exclusions.isEmpty()) {
            dep.setExclusions(def.getExclusions());
        }
    }
}

