/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.net;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.maven.plugin.logging.Log;
import org.jvnet.jaxb.maven.net.AbstractSchemeAwareURILastModifiedResolver;

public class FileURILastModifiedResolver
extends AbstractSchemeAwareURILastModifiedResolver {
    public static final String SCHEME = "file";

    public FileURILastModifiedResolver(Log logger) {
        super(SCHEME, logger);
    }

    @Override
    protected Long getLastModifiedForScheme(URI uri) {
        try {
            File file = new File(uri);
            if (file.exists()) {
                long lastModified = file.lastModified();
                if (lastModified != 0L) {
                    this.getLogger().debug((CharSequence)MessageFormat.format("Last modification timestamp of the file URI [{0}] is [{1,date,yyyy-MM-dd HH:mm:ss.SSS}].", uri, lastModified));
                    return lastModified;
                }
                this.getLogger().error((CharSequence)MessageFormat.format("Could not retrieve the last modification of the file [{0}] .", file.getAbsolutePath()));
            } else {
                this.getLogger().error((CharSequence)MessageFormat.format("File [{0}] does not exist.", file.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            this.getLogger().error((CharSequence)MessageFormat.format("Could not retrieve the last modification of the URI [{0}] .", uri), (Throwable)ex);
        }
        this.getLogger().warn((CharSequence)MessageFormat.format("Last modification of the URI [{0}] is not known.", uri));
        return null;
    }
}

