/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import org.jvnet.jaxb.maven.net.AbstractSchemeAwareURILastModifiedResolver;
import org.jvnet.jaxb.maven.net.URILastModifiedResolver;

public class JarURILastModifiedResolver
extends AbstractSchemeAwareURILastModifiedResolver {
    public static final String SCHEME = "jar";
    public static final String SEPARATOR = "!/";
    private URILastModifiedResolver parent;

    public JarURILastModifiedResolver(Log logger, URILastModifiedResolver parent) {
        super(SCHEME, logger);
        this.parent = (URILastModifiedResolver)Validate.notNull((Object)parent);
    }

    private URILastModifiedResolver getParent() {
        return this.parent;
    }

    @Override
    protected Long getLastModifiedForScheme(URI uri) {
        try {
            URI mainURI = this.getMainURI(uri);
            this.getLogger().debug((CharSequence)MessageFormat.format("Retrieving the last modification timestamp of the URI [{0}] via the main URI [{1}].", uri, mainURI));
            return this.getParent().getLastModified(mainURI);
        }
        catch (Exception ex) {
            this.getLogger().error((CharSequence)MessageFormat.format("Could not retrieve the main URI from the Jar URI [{0}].", uri), (Throwable)ex);
            this.getLogger().warn((CharSequence)MessageFormat.format("Last modification of the URI [{0}] is not known.", uri));
            return null;
        }
    }

    public URI getMainURI(URI uri) throws MalformedURLException, URISyntaxException {
        String uriString = uri.toString();
        URL url = uriString.indexOf(SEPARATOR) < 0 ? new URI(uriString + SEPARATOR).toURL() : uri.toURL();
        String spec = url.getFile();
        int separatorPosition = spec.indexOf(SEPARATOR);
        if (separatorPosition == -1) {
            throw new MalformedURLException(MessageFormat.format("No [!/] found in url spec [{0}].", spec));
        }
        String mainURIString = separatorPosition < 0 ? spec : spec.substring(0, separatorPosition);
        return new URI(mainURIString);
    }
}

