/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.net;

import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import org.jvnet.jaxb.maven.net.SchemeAwareURILastModifiedResolver;

public abstract class AbstractSchemeAwareURILastModifiedResolver
implements SchemeAwareURILastModifiedResolver {
    private final Log logger;
    private final String scheme;

    public AbstractSchemeAwareURILastModifiedResolver(String scheme, Log logger) {
        this.scheme = (String)Validate.notNull((Object)scheme);
        this.logger = (Log)Validate.notNull((Object)logger);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    protected Log getLogger() {
        return this.logger;
    }

    @Override
    public Long getLastModified(URI uri) {
        String scheme = this.getScheme();
        Validate.isTrue((boolean)scheme.equalsIgnoreCase(uri.getScheme()), (String)MessageFormat.format("Invalid scheme [{0}] expected [{1}].", uri.getScheme(), scheme), (Object[])new Object[0]);
        return this.getLastModifiedForScheme(uri);
    }

    protected abstract Long getLastModifiedForScheme(URI var1);
}

