/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.addon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxbcommons.addon.AbstractParameterizableCodeAugmenter;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public abstract class AbstractApplicationContextAwareCodeAugmenter
extends AbstractParameterizableCodeAugmenter {
    protected Log logger = LogFactory.getLog(this.getClass());
    private AbstractXmlApplicationContext applicationContext;
    private boolean dependencyCheck = false;
    private String config;

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public AbstractXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
        this.logger.debug((Object)("Loading configuration from [" + config + "]."));
        try {
            this.applicationContext = new FileSystemXmlApplicationContext(new String[]{"file:" + config}, false);
            this.applicationContext.setClassLoader(this.getClass().getClassLoader());
            this.applicationContext.refresh();
            this.applicationContext.getBeanFactory().autowireBeanProperties((Object)this, 2, this.isDependencyCheck());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

