/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.ai.addon;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxbcommons.addon.AbstractParameterizableCodeAugmenter;
import org.jvnet.jaxbcommons.util.ClassUtils;
import org.jvnet.jaxbcommons.util.CodeModelUtils;
import org.xml.sax.ErrorHandler;

public class AddOn
extends AbstractParameterizableCodeAugmenter {
    protected Log logger = LogFactory.getLog(this.getClass());
    private List interfaces = new ArrayList(10);

    public void setInterface(String name) {
        try {
            Class<?> interfaceClass = Class.forName(name);
            this.interfaces.add(interfaceClass);
        }
        catch (ClassNotFoundException ex) {
            this.logger.error((Object)"Bad interface class name.", (Throwable)ex);
        }
    }

    public List getInterfaces() {
        return this.interfaces;
    }

    public String getOptionName() {
        return "Xautoimplement";
    }

    public String getUsage() {
        return "  -Xautoimplement                :  automactially implements given interfaces";
    }

    protected boolean matches(JCodeModel codeModel, JDefinedClass jinterface, Class theInterface) {
        Method[] methods = theInterface.getMethods();
        for (int index = 0; index < methods.length; ++index) {
            Method method = methods[index];
            if (this.matches(codeModel, jinterface, method)) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(JCodeModel codeModel, JDefinedClass jinterface, Method theMethod) {
        Iterator itr = jinterface.methods();
        while (itr.hasNext()) {
            JMethod m = (JMethod)itr.next();
            if (!this.matches(codeModel, m, theMethod)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(JCodeModel codeModel, JMethod m, Method theMethod) {
        JType[] parameterTypes;
        Class<?>[] parameterClasses;
        if (m.name().equals(theMethod.getName()) && this.matches(codeModel, m.type(), theMethod.getReturnType()) && (parameterClasses = theMethod.getParameterTypes()).length == (parameterTypes = m.listParamTypes()).length) {
            for (int index = 0; index < parameterClasses.length; ++index) {
                JType type = parameterTypes[index];
                Class<?> theClass = parameterClasses[index];
                if (this.matches(codeModel, type, theClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(JCodeModel codeModel, JType type, Class theClass) {
        JClass classType;
        if (Void.TYPE.equals(theClass)) {
            return codeModel.VOID.equals(type);
        }
        if (theClass.isPrimitive()) {
            Class wrapperClass = org.apache.commons.lang.ClassUtils.primitiveToWrapper((Class)theClass);
            classType = codeModel.ref(wrapperClass).getPrimitiveType();
        } else {
            classType = codeModel.ref(theClass);
        }
        return type.equals(classType);
    }

    public boolean run(AnnotatedGrammar grammar, GeneratorContext generatorContext, Options options, ErrorHandler errorHandler) {
        this.logger.debug((Object)"Starting code augmentation.");
        ClassItem[] classItems = grammar.getClasses();
        for (int index = 0; index < classItems.length; ++index) {
            ClassItem classItem = classItems[index];
            ClassContext classContext = generatorContext.getClassContext(classItem);
            this.logger.debug((Object)("Processing [" + classItem.name + "]."));
            this.process(classContext);
        }
        this.logger.debug((Object)"Finished code augmentation.");
        return true;
    }

    protected void process(ClassContext classContext) {
        JCodeModel codeModel = CodeModelUtils.getCodeModel(classContext);
        JDefinedClass jnterface = classContext.ref;
        Iterator iterator = this.getInterfaces().iterator();
        while (iterator.hasNext()) {
            Class theInterface = (Class)iterator.next();
            if (!this.matches(codeModel, jnterface, theInterface)) continue;
            this.logger.debug((Object)("Interface [" + classContext.ref.name() + "] will extend the interface [" + theInterface.getName() + "]."));
            ClassUtils._implements(classContext.ref, codeModel.ref(theInterface));
        }
    }
}

